/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.tileentity;

import java.util.Collection;
import net.minecraft.util.EnumFacing;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.tileentity.InventoryTileEntityBase;

public abstract class InventoryTileEntity
extends InventoryTileEntityBase {
    protected SimpleInventory inventory;
    protected EnumFacingMap<int[]> slotSides;

    public InventoryTileEntity(int inventorySize, String inventoryName, int stackSize) {
        this.inventory = new SimpleInventory(inventorySize, inventoryName, stackSize);
        this.slotSides = EnumFacingMap.newMap();
        for (EnumFacing side : DirectionHelpers.DIRECTIONS) {
            this.slotSides.put(side, new int[0]);
        }
    }

    public InventoryTileEntity(int inventorySize, String inventoryName) {
        this(inventorySize, inventoryName, 64);
    }

    protected void addSlotsToSide(EnumFacing side, Collection<Integer> slots) {
        int[] currentSlots = (int[])this.slotSides.get(side);
        int[] newSlots = new int[currentSlots.length + slots.size()];
        System.arraycopy(currentSlots, 0, newSlots, 0, currentSlots.length);
        int offset = currentSlots.length;
        for (int slot : slots) {
            newSlots[offset++] = slot;
        }
        this.slotSides.put(side, newSlots);
    }

    @Override
    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public int[] func_180463_a(EnumFacing side) {
        return (int[])this.slotSides.get(side);
    }
}

