/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.xml;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.custom.Recipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.component.DummyPropertiesComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;
import org.cyclops.cyclopscore.recipe.xml.CommonRecipeTypeHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SmeltingRecipeTypeHandler
extends CommonRecipeTypeHandler<IngredientRecipeComponent, IngredientRecipeComponent, DummyPropertiesComponent> {
    @Override
    public String getCategoryId() {
        return "furnace_recipe";
    }

    @Override
    public IRecipe<IngredientRecipeComponent, IngredientRecipeComponent, DummyPropertiesComponent> loadRecipe(RecipeHandler recipeHandler, Node recipe) {
        Element recipeElement = (Element)recipe;
        Element input = (Element)recipeElement.getElementsByTagName("input").item(0);
        Element output = (Element)recipeElement.getElementsByTagName("output").item(0);
        ItemStack inputItem = this.getSafeItem(this.getIngredient(recipeHandler, input.getElementsByTagName("item").item(0)));
        ItemStack outputItem = this.getSafeItem(this.getIngredient(recipeHandler, output.getElementsByTagName("item").item(0)));
        float xp = 0.0f;
        if (output.getElementsByTagName("xp").getLength() > 0) {
            xp = Float.parseFloat(output.getElementsByTagName("xp").item(0).getTextContent());
        }
        GameRegistry.addSmelting((ItemStack)inputItem, (ItemStack)outputItem, (float)xp);
        return new Recipe<IngredientRecipeComponent, IngredientRecipeComponent, DummyPropertiesComponent>(new IngredientRecipeComponent(inputItem), new IngredientRecipeComponent(outputItem), new DummyPropertiesComponent());
    }

    private ItemStack getSafeItem(Ingredient ingredient) {
        return ingredient.func_193365_a().length > 0 ? ingredient.func_193365_a()[0] : ItemStack.field_190927_a;
    }
}

