/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.custom.component;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.FluidStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IFluidStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IIngredientRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;

public class IngredientAndFluidStackRecipeComponent
implements IRecipeInput,
IRecipeOutput,
IRecipeProperties,
IIngredientRecipeComponent,
IFluidStackRecipeComponent {
    private final IngredientRecipeComponent ingredient;
    private final FluidStackRecipeComponent fluidStack;
    private float chance;

    public IngredientAndFluidStackRecipeComponent(Ingredient ingredient, FluidStack fluidStack) {
        this.ingredient = new IngredientRecipeComponent(ingredient);
        this.fluidStack = new FluidStackRecipeComponent(fluidStack);
    }

    public IngredientAndFluidStackRecipeComponent(ItemStack itemStack, FluidStack fluidStack) {
        this(itemStack, false, fluidStack);
    }

    public IngredientAndFluidStackRecipeComponent(ItemStack itemStack, boolean nbtSensitive, FluidStack fluidStack) {
        this.ingredient = new IngredientRecipeComponent(itemStack, nbtSensitive);
        this.fluidStack = new FluidStackRecipeComponent(fluidStack);
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient.getIngredient();
    }

    @Override
    public ItemStack getFirstItemStack() {
        return this.ingredient.getFirstItemStack();
    }

    public List<ItemStack> getItemStacks() {
        return this.ingredient.getItemStacks();
    }

    @Override
    public FluidStack getFluidStack() {
        return this.fluidStack.getFluidStack();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IngredientAndFluidStackRecipeComponent)) {
            return false;
        }
        IngredientAndFluidStackRecipeComponent that = (IngredientAndFluidStackRecipeComponent)o;
        if (!this.fluidStack.equals(that.fluidStack)) {
            return false;
        }
        return this.ingredient.equals(that.ingredient);
    }

    public int hashCode() {
        int result = this.ingredient.hashCode();
        result = 31 * result + this.fluidStack.hashCode();
        return result;
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    public IngredientRecipeComponent getIngredientComponent() {
        return this.ingredient;
    }

    public FluidStackRecipeComponent getFluidStackComponent() {
        return this.fluidStack;
    }

    public String toString() {
        return "IngredientAndFluidStackRecipeComponent(ingredient=" + this.getIngredient() + ", fluidStack=" + this.getFluidStack() + ", chance=" + this.getChance() + ")";
    }
}

