/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path.parse;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.cyclops.cyclopscore.nbt.path.parse.INbtPathExpressionParseHandler;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionParseHandlerChild;

public class NbtPathExpressionParseHandlerChildBrackets
implements INbtPathExpressionParseHandler {
    private static final Pattern REGEX_CHILDNAME = Pattern.compile("^\\[\"([^\"]*)\"\\]");

    @Override
    @Nullable
    public INbtPathExpressionParseHandler.HandleResult handlePrefixOf(String nbtPathExpression, int pos) {
        Matcher matcher = REGEX_CHILDNAME.matcher(nbtPathExpression).region(pos, nbtPathExpression.length());
        if (!matcher.find()) {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        String childName = matcher.group(1);
        return new INbtPathExpressionParseHandler.HandleResult(new NbtPathExpressionParseHandlerChild.Expression(childName), 4 + childName.length());
    }
}

