/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.versionchecker;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.tracking.IModVersion;

public class VersionCheckerModCompat
implements IModCompat {
    private static boolean canBeUsed = false;

    @Override
    public void onInit(IInitListener.Step initStep) {
        if (initStep == IInitListener.Step.PREINIT) {
            canBeUsed = CyclopsCore._instance.getModCompatLoader().shouldLoadModCompat(this);
        }
    }

    @Override
    public String getModID() {
        return "VersionChecker";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getComment() {
        return "Version Checker mod support.";
    }

    public static synchronized void sendIMCOutdatedMessage(ModBase mod, IModVersion modVersion) {
        if (canBeUsed) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("modDisplayName", mod.getModName());
            compound.func_74778_a("oldVersion", mod.getReferenceValue(ModBase.REFKEY_MOD_VERSION));
            compound.func_74778_a("newVersion", modVersion.getVersion());
            compound.func_74778_a("updateUrl", modVersion.getUpdateUrl());
            compound.func_74757_a("isDirectLink", true);
            compound.func_74778_a("changeLog", modVersion.getInfo());
            FMLInterModComms.sendRuntimeMessage((Object)mod.getModId(), (String)"VersionChecker", (String)"addUpdate", (NBTTagCompound)compound);
        }
    }
}

