/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.capabilities;

import java.util.Objects;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityTypeGetter;

public class DefaultCapabilityProvider<T>
implements ICapabilityProvider {
    protected final ICapabilityTypeGetter<T> capabilityGetter;
    protected final T capability;

    public DefaultCapabilityProvider(ICapabilityTypeGetter<T> capabilityGetter, T capability) {
        this.capabilityGetter = Objects.requireNonNull(capabilityGetter);
        this.capability = Objects.requireNonNull(capability);
    }

    @Deprecated
    public DefaultCapabilityProvider(Capability<T> capabilityType, T capability) {
        Objects.requireNonNull(capabilityType, "The given capability can not be null, this is probably being called too early during init");
        this.capabilityGetter = () -> capabilityType;
        this.capability = Objects.requireNonNull(capability);
    }

    public Capability<T> getCapabilityType() {
        return this.capabilityGetter.getCapability();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.getCapabilityType() == capability;
    }

    public <T2> T2 getCapability(Capability<T2> capability, EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T2)this.capability;
        }
        return null;
    }
}

