/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.cyclopscore.ingredient.recipe.IRecipeInputDefinitionHandler;
import org.cyclops.cyclopscore.ingredient.recipe.IRecipeOutputDefinitionHandler;
import org.cyclops.cyclopscore.ingredient.recipe.RecipeInputOutputDefinitionHandlers;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;

public class IngredientRecipeHelpers {
    public static <T extends IRecipeInput> Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> toRecipeDefinitionInput(T recipeInput) {
        IRecipeInputDefinitionHandler<?> handler = RecipeInputOutputDefinitionHandlers.REGISTRY.getRecipeInputHandler(recipeInput.getClass());
        Objects.requireNonNull(handler, "No handler was registered for " + recipeInput.getClass());
        return handler.toRecipeDefinitionInput(recipeInput);
    }

    public static <T extends IRecipeOutput> IMixedIngredients toRecipeDefinitionOutput(T recipeOutput) {
        IRecipeOutputDefinitionHandler<?> handler = RecipeInputOutputDefinitionHandlers.REGISTRY.getRecipeOutputHandler(recipeOutput.getClass());
        Objects.requireNonNull(handler, "No handler was registered for " + recipeOutput.getClass());
        return handler.toRecipeDefinitionOutput(recipeOutput);
    }

    public static Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> mergeInputs(IRecipeInput ... recipeInputs) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        for (IRecipeInput recipeInput : recipeInputs) {
            Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> subInput = IngredientRecipeHelpers.toRecipeDefinitionInput(recipeInput);
            for (Map.Entry<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> entry : subInput.entrySet()) {
                List list = (List)inputs.get(entry.getKey());
                if (list == null) {
                    list = Lists.newArrayList();
                    inputs.put(entry.getKey(), list);
                }
                list.addAll((Collection)entry.getValue());
            }
        }
        return inputs;
    }

    public static IMixedIngredients mergeOutputs(IRecipeOutput ... recipeOutputs) {
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        for (IRecipeOutput recipeOutput : recipeOutputs) {
            IMixedIngredients subOutput = IngredientRecipeHelpers.toRecipeDefinitionOutput(recipeOutput);
            for (IngredientComponent component : subOutput.getComponents()) {
                List list = (List)outputs.get(component);
                if (list == null) {
                    list = Lists.newArrayList();
                    outputs.put(component, list);
                }
                list.addAll(subOutput.getInstances(component));
            }
        }
        return new MixedIngredients((Map)outputs);
    }
}

