/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.command;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.config.Configuration;
import org.cyclops.cyclopscore.command.CommandConfig;
import org.cyclops.cyclopscore.config.ConfigProperty;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;

public class CommandConfigSet
extends CommandConfig {
    private ConfigProperty config;
    private String name;

    public CommandConfigSet(ModBase mod, String name, ConfigProperty config) {
        super(mod, name);
        this.name = name;
        this.config = config;
    }

    @Override
    public String getFullCommand() {
        return super.getFullCommand() + " " + this.name;
    }

    @Override
    protected Map<String, ICommand> getSubcommands() {
        return Maps.newHashMap();
    }

    @Override
    public void processCommandHelp(ICommandSender icommandsender, String[] astring) throws CommandException {
        this.printLineToChat(icommandsender, this.config.getComment());
        this.printLineToChat(icommandsender, this.config.getName() + " = " + this.config.getValue());
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender icommandsender, String[] astring) throws CommandException {
        if (astring.length == 0) {
            this.processCommandHelp(icommandsender, astring);
        } else if (astring.length > 1) {
            icommandsender.func_145747_a((ITextComponent)new TextComponentString(L10NHelpers.localize("chat.cyclopscore.command.onlyOneValue", new Object[0])));
        } else {
            Object newValue = Helpers.tryParse(astring[0], this.config.getValue());
            if (newValue != null) {
                Configuration configuration = this.getMod().getConfigHandler().getConfig();
                configuration.load();
                this.config.getCallback().run(newValue);
                this.config.save(configuration, true);
                configuration.save();
                icommandsender.func_145747_a((ITextComponent)new TextComponentString(L10NHelpers.localize("chat.cyclopscore.command.updatedValue", this.name, newValue.toString())));
            } else {
                icommandsender.func_145747_a((ITextComponent)new TextComponentString(L10NHelpers.localize("chat.cyclopscore.command.invalidNewValue", new Object[0])));
            }
        }
    }
}

