/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui;

import java.util.Random;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.GeneralConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.lwjgl.input.Keyboard;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiMainMenuExtensionDevWorld {
    private static final String WORLD_NAME_PREFIX = "cyclops-dev";
    private static final String PRESET_FLAT_WORLD = "3;minecraft:bedrock,3*minecraft:stone,52*minecraft:sandstone;2;";

    @SubscribeEvent
    public static void onMainMenuInit(GuiScreenEvent.InitGuiEvent event) {
        if (GeneralConfig.devWorldButton && event.getGui() instanceof GuiMainMenu) {
            event.getButtonList().add(new GuiButton(666, event.getGui().field_146294_l / 2 + 102, event.getGui().field_146295_m / 4 + 48, 58, 20, L10NHelpers.localize("general.cyclopscore.dev_world", new Object[0])));
        }
    }

    @SubscribeEvent
    public static void onMainMenuClick(GuiScreenEvent.ActionPerformedEvent event) {
        if (GeneralConfig.devWorldButton && event.getGui() instanceof GuiMainMenu && event.getButton().field_146127_k == 666) {
            boolean isShift;
            Minecraft mc = Minecraft.func_71410_x();
            boolean bl = isShift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (!isShift) {
                WorldSummary devWorldSummary = null;
                mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                try {
                    for (WorldSummary worldSummary : mc.func_71359_d().func_75799_b()) {
                        if (!worldSummary.func_75788_b().equals(WORLD_NAME_PREFIX) || devWorldSummary != null && devWorldSummary.func_75784_e() >= worldSummary.func_75784_e()) continue;
                        devWorldSummary = worldSummary;
                    }
                }
                catch (AnvilConverterException e) {
                    CyclopsCore.clog(Level.ERROR, "Couldn't load level list" + e.getMessage());
                    mc.func_147108_a((GuiScreen)new GuiErrorScreen(I18n.func_135052_a((String)"selectWorld.unable_to_load", (Object[])new Object[0]), e.getMessage()));
                }
                if (devWorldSummary != null && mc.func_71359_d().func_90033_f(devWorldSummary.func_75786_a())) {
                    FMLClientHandler.instance().tryLoadExistingWorld(new GuiWorldSelection((GuiScreen)new GuiMainMenu()), devWorldSummary);
                    return;
                }
            }
            WorldSettings worldsettings = new WorldSettings((long)new Random().nextInt(), GameType.CREATIVE, false, false, WorldType.field_77138_c);
            worldsettings.func_77166_b();
            worldsettings.func_82750_a(PRESET_FLAT_WORLD);
            String saveName = GuiCreateWorld.func_146317_a((ISaveFormat)mc.func_71359_d(), (String)WORLD_NAME_PREFIX);
            mc.func_71371_a(saveName, WORLD_NAME_PREFIX, worldsettings);
        }
    }

    @SubscribeEvent
    public static void onWorldStart(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && event.getWorld().func_72912_H().func_76065_j().equals(WORLD_NAME_PREFIX)) {
            event.getWorld().func_82736_K().func_82764_b("doDaylightCycle", "false");
        }
    }
}

