/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import com.google.common.eventbus.Subscribe;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.TinkerPulse;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.fluid.FluidColored;
import slimeknights.tconstruct.library.fluid.FluidMolten;
import slimeknights.tconstruct.shared.block.BlockLiquidSlime;
import slimeknights.tconstruct.smeltery.block.BlockMolten;
import slimeknights.tconstruct.smeltery.block.BlockTinkerFluid;
import slimeknights.tconstruct.tools.TinkerMaterials;

@Pulse(id="TinkerFluids", pulsesRequired="TinkerSmeltery", forced=true)
public class TinkerFluids
extends TinkerPulse {
    public static final String PulseId = "TinkerFluids";
    static final Logger log = Util.getLogger("TinkerFluids");
    @SidedProxy(clientSide="slimeknights.tconstruct.shared.FluidsClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static FluidMolten searedStone;
    public static FluidMolten obsidian;
    public static FluidMolten clay;
    public static FluidMolten dirt;
    public static FluidMolten iron;
    public static FluidMolten gold;
    public static FluidMolten pigIron;
    public static FluidMolten cobalt;
    public static FluidMolten ardite;
    public static FluidMolten manyullyn;
    public static FluidMolten knightslime;
    public static FluidMolten emerald;
    public static FluidMolten glass;
    public static FluidColored blood;
    public static FluidColored milk;
    public static FluidColored blueslime;
    public static FluidColored purpleSlime;
    public static FluidMolten alubrass;
    public static FluidMolten brass;
    public static FluidMolten copper;
    public static FluidMolten tin;
    public static FluidMolten bronze;
    public static FluidMolten zinc;
    public static FluidMolten lead;
    public static FluidMolten nickel;
    public static FluidMolten silver;
    public static FluidMolten electrum;
    public static FluidMolten steel;
    public static FluidMolten aluminum;

    public static void setupFluids() {
        FluidRegistry.enableUniversalBucket();
        iron = TinkerFluids.fluidMetal(TinkerMaterials.iron.getIdentifier(), 11014674);
        iron.setTemperature(769);
        gold = TinkerFluids.fluidMetal("gold", 16176649);
        gold.setTemperature(532);
        gold.setRarity(EnumRarity.RARE);
        pigIron = TinkerFluids.fluidMetal(TinkerMaterials.pigiron);
        pigIron.setTemperature(600);
        pigIron.setRarity(EnumRarity.EPIC);
        cobalt = TinkerFluids.fluidMetal(TinkerMaterials.cobalt);
        cobalt.setTemperature(950);
        cobalt.setRarity(EnumRarity.RARE);
        ardite = TinkerFluids.fluidMetal(TinkerMaterials.ardite);
        ardite.setTemperature(860);
        ardite.setRarity(EnumRarity.RARE);
        manyullyn = TinkerFluids.fluidMetal(TinkerMaterials.manyullyn);
        manyullyn.setTemperature(1000);
        manyullyn.setRarity(EnumRarity.RARE);
        knightslime = TinkerFluids.fluidMetal(TinkerMaterials.knightslime);
        knightslime.setTemperature(520);
        knightslime.setRarity(EnumRarity.EPIC);
        alubrass = TinkerFluids.fluidMetal("alubrass", 15524679);
        alubrass.setTemperature(500);
        brass = TinkerFluids.fluidMetal("brass", 15590283);
        brass.setTemperature(470);
        copper = TinkerFluids.fluidMetal(TinkerMaterials.copper);
        copper.setTemperature(542);
        tin = TinkerFluids.fluidMetal("tin", 0xC1CDDC);
        tin.setTemperature(350);
        bronze = TinkerFluids.fluidMetal(TinkerMaterials.bronze);
        bronze.setTemperature(475);
        zinc = TinkerFluids.fluidMetal("zinc", 13889512);
        zinc.setTemperature(375);
        lead = TinkerFluids.fluidMetal(TinkerMaterials.lead);
        lead.setTemperature(400);
        nickel = TinkerFluids.fluidMetal("nickel", 13162115);
        nickel.setTemperature(727);
        silver = TinkerFluids.fluidMetal(TinkerMaterials.silver);
        silver.setTemperature(480);
        silver.setRarity(EnumRarity.RARE);
        electrum = TinkerFluids.fluidMetal(TinkerMaterials.electrum);
        electrum.setTemperature(500);
        electrum.setRarity(EnumRarity.EPIC);
        steel = TinkerFluids.fluidMetal(TinkerMaterials.steel);
        steel.setTemperature(681);
        aluminum = TinkerFluids.fluidMetal("aluminum", 15720661);
        aluminum.setTemperature(330);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        if (TinkerFluids.isSmelteryLoaded()) {
            searedStone = TinkerFluids.fluidStone("stone", 0x777777);
            searedStone.setTemperature(800);
            TinkerFluids.registerMoltenBlock((IForgeRegistry<Block>)registry, searedStone);
            obsidian = TinkerFluids.fluidStone(TinkerMaterials.obsidian.getIdentifier(), 2887001);
            obsidian.setTemperature(1000);
            TinkerFluids.registerMoltenBlock((IForgeRegistry<Block>)registry, obsidian);
            clay = TinkerFluids.fluidStone("clay", 13005907);
            clay.setTemperature(700);
            TinkerFluids.registerMoltenBlock((IForgeRegistry<Block>)registry, clay);
            dirt = TinkerFluids.fluidStone("dirt", 10913124);
            dirt.setTemperature(500);
            TinkerFluids.registerMoltenBlock((IForgeRegistry<Block>)registry, dirt);
            emerald = TinkerFluids.fluidMetal("emerald", 5826446);
            emerald.setTemperature(999);
            TinkerFluids.registerMoltenBlock((IForgeRegistry<Block>)registry, emerald);
            glass = TinkerFluids.fluidMetal("glass", 12645886);
            glass.setTemperature(625);
            TinkerFluids.registerMoltenBlock((IForgeRegistry<Block>)registry, glass);
            blood = TinkerFluids.fluidClassic("blood", 0x540000);
            blood.setTemperature(336);
            TinkerFluids.registerClassicBlock((IForgeRegistry<Block>)registry, blood);
        }
        milk = TinkerFluids.fluidMilk("milk", 0xFFFFFF);
        milk.setTemperature(320);
        TinkerFluids.registerClassicBlock((IForgeRegistry<Block>)registry, milk);
        if (TinkerFluids.isWorldLoaded()) {
            blueslime = TinkerFluids.fluidClassic("blueslime", -278400779);
            blueslime.setTemperature(310);
            blueslime.setViscosity(1500);
            blueslime.setDensity(1500);
            TinkerFluids.registerBlock((IForgeRegistry<Block>)registry, new BlockLiquidSlime(blueslime, Material.field_151586_h), blueslime.getName());
        }
        if (TinkerFluids.isWorldLoaded() || TinkerFluids.isSmelteryLoaded()) {
            purpleSlime = TinkerFluids.fluidClassic("purpleslime", -271436033);
            purpleSlime.setTemperature(370);
            purpleSlime.setViscosity(1600);
            purpleSlime.setDensity(1600);
            TinkerFluids.registerBlock((IForgeRegistry<Block>)registry, new BlockLiquidSlime(purpleSlime, Material.field_151586_h), purpleSlime.getName());
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        if (TinkerFluids.isSmelteryLoaded()) {
            FluidRegistry.addBucketForFluid((Fluid)searedStone);
            FluidRegistry.addBucketForFluid((Fluid)obsidian);
            FluidRegistry.addBucketForFluid((Fluid)clay);
            FluidRegistry.addBucketForFluid((Fluid)dirt);
            FluidRegistry.addBucketForFluid((Fluid)emerald);
            FluidRegistry.addBucketForFluid((Fluid)glass);
            FluidRegistry.addBucketForFluid((Fluid)blood);
        }
        if (TinkerFluids.isWorldLoaded()) {
            FluidRegistry.addBucketForFluid((Fluid)blueslime);
        }
        if (TinkerFluids.isWorldLoaded() || TinkerFluids.isSmelteryLoaded()) {
            FluidRegistry.addBucketForFluid((Fluid)purpleSlime);
        }
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        proxy.registerModels();
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    private static FluidMolten fluidMetal(slimeknights.tconstruct.library.materials.Material material) {
        return TinkerFluids.fluidMetal(material.getIdentifier(), material.materialTextColor);
    }

    private static FluidMolten fluidMetal(String name, int color) {
        FluidMolten fluid = new FluidMolten(name, color);
        return TinkerFluids.registerFluid(fluid);
    }

    private static FluidMolten fluidLiquid(String name, int color) {
        FluidMolten fluid = new FluidMolten(name, color, FluidMolten.ICON_LiquidStill, FluidMolten.ICON_LiquidFlowing);
        return TinkerFluids.registerFluid(fluid);
    }

    private static FluidMolten fluidStone(String name, int color) {
        FluidMolten fluid = new FluidMolten(name, color, FluidColored.ICON_StoneStill, FluidColored.ICON_StoneFlowing);
        return TinkerFluids.registerFluid(fluid);
    }

    private static FluidColored fluidClassic(String name, int color) {
        FluidColored fluid = new FluidColored(name, color, FluidColored.ICON_LiquidStill, FluidColored.ICON_LiquidFlowing);
        return TinkerFluids.registerFluid(fluid);
    }

    private static FluidColored fluidMilk(String name, int color) {
        FluidColored fluid = new FluidColored(name, color, FluidColored.ICON_MilkStill, FluidColored.ICON_MilkFlowing);
        return TinkerFluids.registerFluid(fluid);
    }

    protected static <T extends Fluid> T registerFluid(T fluid) {
        fluid.setUnlocalizedName(Util.prefix(fluid.getName()));
        FluidRegistry.registerFluid(fluid);
        return fluid;
    }

    public static BlockFluidBase registerClassicBlock(IForgeRegistry<Block> registry, Fluid fluid) {
        return (BlockFluidBase)TinkerFluids.registerBlock(registry, new BlockTinkerFluid(fluid, Material.field_151586_h), fluid.getName());
    }

    public static BlockMolten registerMoltenBlock(IForgeRegistry<Block> registry, Fluid fluid) {
        return TinkerFluids.registerBlock(registry, new BlockMolten(fluid), "molten_" + fluid.getName());
    }

    static {
        TinkerFluids.setupFluids();
    }
}

