/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.casting;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;

public class CastingRecipeWrapper
implements IRecipeWrapper {
    protected final List<ItemStack> cast;
    protected final List<FluidStack> inputFluid;
    protected List<ItemStack> output;
    public final IDrawable castingBlock;
    private final CastingRecipe recipe;

    public CastingRecipeWrapper(List<ItemStack> casts, CastingRecipe recipe, IDrawable castingBlock) {
        this.cast = casts;
        this.recipe = recipe;
        this.inputFluid = ImmutableList.of((Object)recipe.getFluid());
        this.output = ImmutableList.of((Object)recipe.getResult());
        this.castingBlock = castingBlock;
    }

    public CastingRecipeWrapper(CastingRecipe recipe, IDrawable castingBlock) {
        this.cast = recipe.cast != null ? recipe.cast.getInputs() : ImmutableList.of();
        this.inputFluid = ImmutableList.of((Object)recipe.getFluid());
        this.recipe = recipe;
        this.output = ImmutableList.of((Object)recipe.getResult());
        this.castingBlock = castingBlock;
    }

    public boolean hasCast() {
        return this.recipe.cast != null;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, (List)ImmutableList.of(this.cast));
        ingredients.setInputs(FluidStack.class, this.inputFluid);
        ingredients.setOutputs(ItemStack.class, this.lazyInitOutput());
    }

    public List<ItemStack> lazyInitOutput() {
        if (this.output == null) {
            if (this.recipe.getResult() == null) {
                return ImmutableList.of();
            }
            this.output = ImmutableList.of((Object)this.recipe.getResult());
        }
        return this.output;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.castingBlock.draw(minecraft, 59, 42);
        String s = String.format("%d s", this.recipe.getTime() / 20);
        int x = 92;
        minecraft.field_71466_p.func_78276_b(s, x -= minecraft.field_71466_p.func_78256_a(s) / 2, 16, Color.gray.getRGB());
        if (this.recipe.consumesCast()) {
            minecraft.field_71466_p.func_78276_b(Util.translate("gui.jei.casting.consume", new Object[0]), 78, 48, 0xAA0000);
        }
    }

    public boolean isValid(boolean checkCast) {
        return !this.inputFluid.isEmpty() && this.inputFluid.get(0) != null && (!checkCast || !this.hasCast() || !this.cast.isEmpty() && !this.cast.get(0).func_190926_b()) && !this.output.isEmpty() && !this.output.get(0).func_190926_b();
    }
}

