/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.gadgets.entity.ExplosionEFLN;
import slimeknights.tconstruct.tools.common.network.EntityMovementChangePacket;

public class Exploder {
    public final double r;
    public final double rr;
    public final int dist;
    public final double explosionStrength;
    public final int blocksPerIteration;
    public final int x;
    public final int y;
    public final int z;
    public final World world;
    public final Entity exploder;
    public final ExplosionEFLN explosion;
    protected int currentRadius;
    private int curX;
    private int curY;
    private int curZ;
    protected List<ItemStack> droppedItems;

    public Exploder(World world, ExplosionEFLN explosion, Entity exploder, BlockPos location, double r, double explosionStrength, int blocksPerIteration) {
        this.r = r;
        this.world = world;
        this.explosion = explosion;
        this.exploder = exploder;
        this.rr = r * r;
        this.dist = (int)r + 1;
        this.explosionStrength = explosionStrength;
        this.blocksPerIteration = blocksPerIteration;
        this.currentRadius = 0;
        this.x = location.func_177958_n();
        this.y = location.func_177956_o();
        this.z = location.func_177952_p();
        this.curX = 0;
        this.curY = 0;
        this.curZ = 0;
        this.droppedItems = Lists.newArrayList();
    }

    public static void startExplosion(World world, ExplosionEFLN explosion, Entity entity, BlockPos location, double r, double explosionStrength) {
        Exploder exploder = new Exploder(world, explosion, entity, location, r, explosionStrength, Math.max(50, (int)(r * r * r / 10.0)));
        exploder.handleEntities();
        world.func_184133_a(null, location, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        MinecraftForge.EVENT_BUS.register((Object)exploder);
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.world == this.world && event.phase == TickEvent.Phase.END && !this.iteration()) {
            this.finish();
        }
    }

    void handleEntities() {
        Predicate predicate = entity -> entity != null && !entity.func_180427_aV() && EntitySelectors.field_180132_d.apply(entity) && EntitySelectors.field_94557_a.apply(entity) && entity.func_174791_d().func_186679_c((double)this.x, (double)this.y, (double)this.z) <= this.r * this.r;
        List list = this.world.func_175674_a(this.exploder, new AxisAlignedBB((double)this.x - this.r - 1.0, (double)this.y - this.r - 1.0, (double)this.z - this.r - 1.0, (double)this.x + this.r + 1.0, (double)this.y + this.r + 1.0, (double)this.z + this.r + 1.0), predicate);
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this.explosion, (List)list, (double)(this.r * 2.0));
        for (Entity entity2 : list) {
            Vec3d dir = entity2.func_174791_d().func_178788_d(this.exploder.func_174791_d().func_72441_c(0.0, -this.r / 2.0, 0.0));
            double str = (this.r - dir.func_72433_c()) / this.r;
            str = Math.max(0.3, str);
            dir = dir.func_72432_b();
            dir = dir.func_186678_a(this.explosionStrength * str * 0.3);
            entity2.func_70024_g(dir.field_72450_a, dir.field_72448_b + 0.5, dir.field_72449_c);
            entity2.func_70097_a(DamageSource.func_94539_a((Explosion)this.explosion), (float)(str * this.explosionStrength));
            if (!(entity2 instanceof EntityPlayerMP)) continue;
            TinkerNetwork.sendTo((AbstractPacket)new EntityMovementChangePacket(entity2), (EntityPlayerMP)entity2);
        }
    }

    private void finish() {
        int d = (int)this.r / 2;
        BlockPos pos = new BlockPos(this.x - d, this.y - d, this.z - d);
        Random random = new Random();
        ArrayList aggregatedDrops = Lists.newArrayList();
        for (ItemStack drop : this.droppedItems) {
            boolean notInList = true;
            for (ItemStack stack : aggregatedDrops) {
                if (!ItemStack.func_179545_c((ItemStack)drop, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)drop, (ItemStack)stack)) continue;
                stack.func_190917_f(drop.func_190916_E());
                notInList = false;
                break;
            }
            if (!notInList) continue;
            aggregatedDrops.add(drop);
        }
        for (ItemStack drop : aggregatedDrops) {
            ItemStack dropItemstack;
            int stacksize = drop.func_190916_E();
            do {
                BlockPos spawnPos = pos.func_177982_a(random.nextInt((int)this.r), random.nextInt((int)this.r), random.nextInt((int)this.r));
                dropItemstack = drop.func_77946_l();
                dropItemstack.func_190920_e(Math.min(stacksize, 64));
                Block.func_180635_a((World)this.world, (BlockPos)spawnPos, (ItemStack)dropItemstack);
            } while ((stacksize -= dropItemstack.func_190916_E()) > 0);
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    private boolean iteration() {
        int count = 0;
        this.explosion.func_180342_d();
        while (count < this.blocksPerIteration && this.currentRadius < (int)this.r + 1) {
            BlockPos pos;
            IBlockState state;
            double d = this.curX * this.curX + this.curY * this.curY + this.curZ * this.curZ;
            if (d <= this.rr && !(state = this.world.func_180495_p(pos = new BlockPos(this.x + this.curX, this.y + this.curY, this.z + this.curZ))).func_177230_c().isAir(state, (IBlockAccess)this.world, pos)) {
                double f = this.explosionStrength * (1.0 - d / this.rr);
                float f2 = this.exploder != null ? this.exploder.func_180428_a((Explosion)this.explosion, this.world, pos, state) : state.func_177230_c().getExplosionResistance(this.world, pos, null, (Explosion)this.explosion);
                if (f > 0.0 && (this.exploder == null || this.exploder.func_174816_a((Explosion)this.explosion, this.world, pos, state, (float)(f -= (double)((f2 + 0.3f) * 0.3f))))) {
                    ++count;
                    this.explosion.addAffectedBlock(pos);
                }
            }
            this.step();
        }
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this.explosion, Collections.emptyList(), (double)(this.r * 2.0));
        this.explosion.func_180343_e().forEach(this::explodeBlock);
        return count == this.blocksPerIteration;
    }

    private void step() {
        if (++this.curX > this.currentRadius) {
            this.curX = -this.currentRadius;
            if (++this.curZ > this.currentRadius) {
                this.curZ = -this.currentRadius;
                if (--this.curY < -this.currentRadius) {
                    ++this.currentRadius;
                    this.curX = this.curZ = -this.currentRadius;
                    this.curY = this.currentRadius;
                }
            }
        }
        if (this.curY != -this.currentRadius && this.curY != this.currentRadius && this.curZ != -this.currentRadius && this.curZ != this.currentRadius && this.curX > -this.currentRadius) {
            this.curX = this.currentRadius;
        }
    }

    private void explodeBlock(BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!this.world.field_72995_K && block.func_149659_a((Explosion)this.explosion)) {
            List drops = block.getDrops((IBlockAccess)this.world, pos, state, 0);
            ForgeEventFactory.fireBlockHarvesting((List)drops, (World)this.world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, null);
            this.droppedItems.addAll(drops);
        }
        if (this.world instanceof WorldServer) {
            ((WorldServer)this.world).func_180505_a(EnumParticleTypes.EXPLOSION_NORMAL, true, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 2, 0.0, 0.0, 0.0, 0.0, new int[0]);
            ((WorldServer)this.world).func_180505_a(EnumParticleTypes.SMOKE_LARGE, true, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
        }
        block.onBlockExploded(this.world, pos, (Explosion)this.explosion);
    }
}

