/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.IOException;
import javax.vecmath.Vector3f;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;

public class NBTUtils {
    public static void readFloatList(NBTTagList list, float[] array) {
        int count = Math.min(array.length, list.func_74745_c());
        for (int i = 0; i < count; ++i) {
            array[i] = list.func_150308_e(i);
        }
    }

    public static NBTTagList writeFloatList(NBTTagList list, float[] array) {
        for (int i = 0; i < array.length; ++i) {
            list.func_74742_a((NBTBase)new NBTTagFloat(array[i]));
        }
        return list;
    }

    public static void readFloatList(NBTTagList list, Vector3f vector) {
        if (list.func_74745_c() != 3) {
            return;
        }
        vector.x = list.func_150308_e(0);
        vector.y = list.func_150308_e(1);
        vector.z = list.func_150308_e(2);
    }

    public static NBTTagList writeFloatList(NBTTagList list, Vector3f vector) {
        list.func_74742_a((NBTBase)new NBTTagFloat(vector.x));
        list.func_74742_a((NBTBase)new NBTTagFloat(vector.y));
        list.func_74742_a((NBTBase)new NBTTagFloat(vector.z));
        return list;
    }

    public static NBTTagCompound readInfiniteTag(ByteBuf buf) {
        int i = buf.readerIndex();
        byte b0 = buf.readByte();
        if (b0 == 0) {
            return null;
        }
        buf.readerIndex(i);
        try {
            return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)NBTSizeTracker.field_152451_a);
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }
}

