/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import mchorse.mclib.config.Config;
import mchorse.mclib.config.values.IConfigValue;
import mchorse.mclib.config.values.Value;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConfigCategory {
    public final String id;
    public Config config;
    public final Map<String, IConfigValue> values = new LinkedHashMap<String, IConfigValue>();

    public ConfigCategory(String id) {
        this.id = id;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTitle() {
        return this.config.getCategoryTitle(this.id);
    }

    @SideOnly(value=Side.CLIENT)
    public String getTitleKey() {
        return this.config.getCategoryTitleKey(this.id);
    }

    @SideOnly(value=Side.CLIENT)
    public String getTooltip() {
        return this.config.getCategoryTooltip(this.id);
    }

    @SideOnly(value=Side.CLIENT)
    public String getTooltipKey() {
        return this.config.getCategoryTooltipKey(this.id);
    }

    public void register(String id, IConfigValue value) {
        if (value instanceof Value) {
            ((Value)value).category = this;
        }
        this.values.put(id, value);
    }

    public boolean isVisible() {
        for (IConfigValue value : this.values.values()) {
            if (!value.isVisible()) continue;
            return true;
        }
        return false;
    }

    public JsonObject toJSON() {
        JsonObject object = new JsonObject();
        for (IConfigValue value : this.values.values()) {
            object.add(value.getId(), value.toJSON());
        }
        return object;
    }

    public void fromJSON(JsonObject object) {
        for (Map.Entry entry : object.entrySet()) {
            IConfigValue value = this.values.get(entry.getKey());
            if (value == null) continue;
            value.reset();
            value.fromJSON((JsonElement)entry.getValue());
        }
    }
}

