/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.utils;

import java.util.List;
import java.util.function.Consumer;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiSlotElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;

public class GuiInventoryElement
extends GuiElement {
    public Consumer<ItemStack> callback;
    public GuiSlotElement linked;
    protected Area inventory = new Area();
    protected Area hotbar = new Area();
    private ItemStack active = ItemStack.field_190927_a;

    public static void drawItemStack(ItemStack stack, int x, int y, String altText) {
        GuiInventoryElement.drawItemStack(stack, x, y, 200, altText);
    }

    public static void drawItemStack(ItemStack stack, int x, int y, int z, String altText) {
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        itemRender.field_77023_b = z;
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        itemRender.func_180450_b(stack, x, y);
        itemRender.func_180453_a(font, stack, x, y, altText);
        itemRender.field_77023_b = 0.0f;
        GlStateManager.func_179121_F();
    }

    public static void drawItemTooltip(ItemStack stack, EntityPlayerSP player, FontRenderer providedFont, int x, int y) {
        if (stack.func_190926_b()) {
            return;
        }
        List list = stack.func_82840_a((EntityPlayer)player, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77953_t().field_77937_e + (String)list.get(i));
                continue;
            }
            list.set(i, TextFormatting.GRAY + (String)list.get(i));
        }
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        GuiUtils.preItemToolTip((ItemStack)stack);
        GuiUtils.drawHoveringText((List)list, (int)x, (int)y, (int)screen.field_146294_l, (int)screen.field_146295_m, (int)-1, (FontRenderer)(font == null ? providedFont : font));
        GuiUtils.postItemToolTip();
    }

    public GuiInventoryElement(Minecraft mc, Consumer<ItemStack> callback) {
        super(mc);
        this.callback = callback;
        this.flex().wh(200, 100);
    }

    public void link(GuiSlotElement slot) {
        this.linked = slot;
        this.setVisible(true);
    }

    public void unlink() {
        this.linked = null;
        this.setVisible(false);
    }

    @Override
    public void resize() {
        super.resize();
        int tile = 20;
        int row = 9 * tile;
        int fourth = this.area.h / 4;
        this.inventory.set(this.area.mx(row), this.area.y + (this.area.h - fourth) / 2 - 30, row, 3 * tile);
        this.hotbar.set(this.area.mx(row), this.area.ey() - (fourth + tile) / 2, row, tile);
    }

    @Override
    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context)) {
            return true;
        }
        if (!this.area.isInside(context)) {
            this.setVisible(false);
            return false;
        }
        boolean inventory = this.inventory.isInside(context);
        boolean hotbar = this.hotbar.isInside(context);
        if ((inventory || hotbar) && context.mouseButton == 0) {
            Area area = inventory ? this.inventory : this.hotbar;
            int x = (context.mouseX - area.x - 2) / 20;
            int y = (context.mouseY - area.y - 2) / 20;
            if (inventory) {
                ++y;
            }
            if (x >= 9 || y >= 4 || x < 0 || y < 0 || !this.visible) {
                return true;
            }
            int index = x + y * 9;
            if (this.callback != null) {
                this.callback.accept((ItemStack)Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a.get(index));
                return true;
            }
        }
        return false;
    }

    @Override
    public void draw(GuiContext context) {
        this.active = null;
        int border = -1;
        int fourth = this.area.y(0.75f);
        if (McLib.enableBorders.get()) {
            Gui.func_73734_a((int)(this.area.x + 1), (int)this.area.y, (int)(this.area.ex() - 1), (int)this.area.ey(), (int)-16777216);
            Gui.func_73734_a((int)this.area.x, (int)(this.area.y + 1), (int)this.area.ex(), (int)(this.area.ey() - 1), (int)-16777216);
            Gui.func_73734_a((int)(this.area.x + 1), (int)(this.area.y + 1), (int)(this.area.ex() - 1), (int)(this.area.ey() - 1), (int)border);
            Gui.func_73734_a((int)(this.area.x + 2), (int)(this.area.y + 2), (int)(this.area.ex() - 2), (int)fourth, (int)-3750202);
            Gui.func_73734_a((int)(this.area.x + 1), (int)fourth, (int)(this.area.ex() - 1), (int)(this.area.ey() - 1), (int)-14540254);
        } else {
            Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)this.area.ex(), (int)this.area.ey(), (int)border);
            Gui.func_73734_a((int)(this.area.x + 1), (int)(this.area.y + 1), (int)(this.area.ex() - 1), (int)fourth, (int)-3750202);
            Gui.func_73734_a((int)this.area.x, (int)fourth, (int)this.area.ex(), (int)this.area.ey(), (int)-14540254);
        }
        GlStateManager.func_179126_j();
        RenderHelper.func_74520_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        NonNullList inventory = player.field_71071_by.field_70462_a;
        int index = this.drawGrid(context, this.inventory, (NonNullList<ItemStack>)inventory, -1, 9, inventory.size());
        index = this.drawGrid(context, this.hotbar, (NonNullList<ItemStack>)inventory, index, 0, 9);
        if (index != -1) {
            context.tooltip.set(context, this);
            this.active = (ItemStack)inventory.get(index);
        }
        GlStateManager.func_179097_i();
        RenderHelper.func_74518_a();
        GuiDraw.drawLockedArea(this, McLib.enableBorders.get() ? 1 : 0);
        super.draw(context);
    }

    private int drawGrid(GuiContext context, Area area, NonNullList<ItemStack> inventory, int index, int i, int c) {
        for (int j = 0; j < c - i; ++j) {
            int k = i + j;
            ItemStack stack = (ItemStack)inventory.get(k);
            int x = j % 9;
            int y = j / 9;
            x = area.x + 2 + 20 * x;
            y = area.y + 2 + 20 * y;
            int diffX = context.mouseX - x;
            int diffY = context.mouseY - y;
            boolean hover = diffX >= 0 && diffX < 18 && diffY >= 0 && diffY < 18;
            Gui.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 17), (int)(y + 17), (int)(area == this.hotbar ? -1442840576 : 0x44000000));
            GuiInventoryElement.drawItemStack(stack, x, y, null);
            if (!hover) continue;
            Gui.func_73734_a((int)(x - 2), (int)(y - 2), (int)(x + 18), (int)(y + 18), (int)(-872415232 + McLib.primaryColor.get()));
            index = k;
        }
        return index;
    }

    @Override
    public void drawTooltip(GuiContext context, Area area) {
        super.drawTooltip(context, area);
        GuiInventoryElement.drawItemTooltip(this.active, this.mc.field_71439_g, this.font, context.mouseX, context.mouseY);
    }
}

