/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.input;

import javax.vecmath.Vector3d;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;

public class GuiTransformations
extends GuiElement {
    public GuiTrackpadElement tx;
    public GuiTrackpadElement ty;
    public GuiTrackpadElement tz;
    public GuiTrackpadElement sx;
    public GuiTrackpadElement sy;
    public GuiTrackpadElement sz;
    public GuiTrackpadElement rx;
    public GuiTrackpadElement ry;
    public GuiTrackpadElement rz;
    public GuiToggleElement one;

    public GuiTransformations(Minecraft mc) {
        super(mc);
        this.tx = new GuiTrackpadElement(mc, value -> this.setT((double)value, this.ty.value, this.tz.value)).block();
        this.tx.tooltip(IKey.lang("mclib.gui.transforms.x"));
        this.ty = new GuiTrackpadElement(mc, value -> this.setT(this.tx.value, (double)value, this.tz.value)).block();
        this.ty.tooltip(IKey.lang("mclib.gui.transforms.y"));
        this.tz = new GuiTrackpadElement(mc, value -> this.setT(this.tx.value, this.ty.value, (double)value)).block();
        this.tz.tooltip(IKey.lang("mclib.gui.transforms.z"));
        this.sx = new GuiTrackpadElement(mc, value -> {
            boolean one = this.one.isToggled();
            this.setS((double)value, one ? value : this.sy.value, one ? value : this.sz.value);
        });
        this.sx.tooltip(IKey.lang("mclib.gui.transforms.x"));
        this.sy = new GuiTrackpadElement(mc, value -> this.setS(this.sx.value, (double)value, this.sz.value));
        this.sy.tooltip(IKey.lang("mclib.gui.transforms.y"));
        this.sz = new GuiTrackpadElement(mc, value -> this.setS(this.sx.value, this.sy.value, (double)value));
        this.sz.tooltip(IKey.lang("mclib.gui.transforms.z"));
        this.rx = new GuiTrackpadElement(mc, value -> this.setR((double)value, this.ry.value, this.rz.value)).degrees();
        this.rx.tooltip(IKey.lang("mclib.gui.transforms.x"));
        this.ry = new GuiTrackpadElement(mc, value -> this.setR(this.rx.value, (double)value, this.rz.value)).degrees();
        this.ry.tooltip(IKey.lang("mclib.gui.transforms.y"));
        this.rz = new GuiTrackpadElement(mc, value -> this.setR(this.rx.value, this.ry.value, (double)value)).degrees();
        this.rz.tooltip(IKey.lang("mclib.gui.transforms.z"));
        this.one = new GuiToggleElement(mc, IKey.EMPTY, false, b -> {
            boolean one = b.isToggled();
            this.updateScaleFields();
            if (!one) {
                this.sy.setValueAndNotify(this.sx.value);
                this.sz.setValueAndNotify(this.sx.value);
            }
        });
        this.one.flex().relative(this.sx).x(1.0f).y(-13).wh(11, 11).anchorX(1.0f);
        GuiElement first = new GuiElement(mc);
        GuiElement second = new GuiElement(mc);
        GuiElement third = new GuiElement(mc);
        first.flex().relative(this).w(1.0f).h(20).row(5).height(20);
        first.add(this.tx, this.sx, this.rx);
        second.flex().relative(this).y(0.5f, -10).w(1.0f).h(20).row(5).height(20);
        second.add(this.ty, this.sy, this.ry);
        third.flex().relative(this).y(1.0f, -20).w(1.0f).h(20).row(5).height(20);
        third.add(this.tz, this.sz, this.rz);
        this.add(first, second, third, this.one);
    }

    public void resetScale() {
        this.one.toggled(false);
        this.updateScaleFields();
    }

    public void updateScaleFields() {
        this.sy.setVisible(!this.one.isToggled());
        this.sz.setVisible(!this.one.isToggled());
    }

    public void fillT(double x, double y, double z) {
        this.tx.setValue(x);
        this.ty.setValue(y);
        this.tz.setValue(z);
    }

    public void fillS(double x, double y, double z) {
        this.resetScale();
        this.sx.setValue(x);
        this.sy.setValue(y);
        this.sz.setValue(z);
    }

    public void fillR(double x, double y, double z) {
        this.rx.setValue(x);
        this.ry.setValue(y);
        this.rz.setValue(z);
    }

    public void setT(double x, double y, double z) {
    }

    public void setS(double x, double y, double z) {
    }

    public void setR(double x, double y, double z) {
    }

    @Override
    public GuiContextMenu createContextMenu(GuiContext context) {
        GuiSimpleContextMenu menu = new GuiSimpleContextMenu(context.mc);
        NBTTagList transforms = null;
        try {
            NBTTagCompound tag = JsonToNBT.func_180713_a((String)("{Transforms:" + GuiScreen.func_146277_j() + "}"));
            NBTTagList list = tag.func_150295_c("Transforms", 6);
            if (list.func_74745_c() >= 9) {
                transforms = list;
            }
        }
        catch (Exception tag) {
            // empty catch block
        }
        menu.action(Icons.COPY, IKey.lang("mclib.gui.transforms.context.copy"), () -> this.copyTransformations());
        if (transforms != null) {
            NBTTagList innerList = transforms;
            menu.action(Icons.PASTE, IKey.lang("mclib.gui.transforms.context.paste"), () -> this.pasteAll(innerList));
            menu.action(Icons.ALL_DIRECTIONS, IKey.lang("mclib.gui.transforms.context.paste_translation"), () -> this.pasteTranslation(innerList));
            menu.action(Icons.MAXIMIZE, IKey.lang("mclib.gui.transforms.context.paste_scale"), () -> this.pasteScale(innerList));
            menu.action(Icons.REFRESH, IKey.lang("mclib.gui.transforms.context.paste_rotation"), () -> this.pasteRotation(innerList));
        }
        return menu;
    }

    private void copyTransformations() {
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagDouble(this.tx.value));
        list.func_74742_a((NBTBase)new NBTTagDouble(this.ty.value));
        list.func_74742_a((NBTBase)new NBTTagDouble(this.tz.value));
        list.func_74742_a((NBTBase)new NBTTagDouble(this.sx.value));
        list.func_74742_a((NBTBase)new NBTTagDouble(this.sy.value));
        list.func_74742_a((NBTBase)new NBTTagDouble(this.sz.value));
        list.func_74742_a((NBTBase)new NBTTagDouble(this.rx.value));
        list.func_74742_a((NBTBase)new NBTTagDouble(this.ry.value));
        list.func_74742_a((NBTBase)new NBTTagDouble(this.rz.value));
        GuiScreen.func_146275_d((String)list.toString());
    }

    public void pasteAll(NBTTagList list) {
        this.pasteTranslation(list);
        this.pasteScale(list);
        this.pasteRotation(list);
    }

    public void pasteTranslation(NBTTagList list) {
        Vector3d translation = this.getVector(list, 0);
        this.tx.setValue(translation.x);
        this.ty.setValue(translation.y);
        this.tz.setValueAndNotify(translation.z);
    }

    public void pasteScale(NBTTagList list) {
        Vector3d scale = this.getVector(list, 3);
        this.sz.setValue(scale.z);
        this.sy.setValue(scale.y);
        this.sx.setValueAndNotify(scale.x);
    }

    public void pasteRotation(NBTTagList list) {
        Vector3d rotation = this.getVector(list, 6);
        this.rx.setValue(rotation.x);
        this.ry.setValue(rotation.y);
        this.rz.setValueAndNotify(rotation.z);
    }

    private Vector3d getVector(NBTTagList list, int offset) {
        Vector3d result = new Vector3d();
        result.x = list.func_150309_d(offset);
        result.y = list.func_150309_d(offset + 1);
        result.z = list.func_150309_d(offset + 2);
        return result;
    }

    @Override
    public void draw(GuiContext context) {
        this.font.func_175063_a(I18n.func_135052_a((String)"mclib.gui.transforms.translate", (Object[])new Object[0]), (float)this.tx.area.x, (float)(this.tx.area.y - 12), 0xFFFFFF);
        this.font.func_175063_a(I18n.func_135052_a((String)"mclib.gui.transforms.scale", (Object[])new Object[0]), (float)this.sx.area.x, (float)(this.sx.area.y - 12), 0xFFFFFF);
        this.font.func_175063_a(I18n.func_135052_a((String)"mclib.gui.transforms.rotate", (Object[])new Object[0]), (float)this.rx.area.x, (float)(this.rx.area.y - 12), 0xFFFFFF);
        super.draw(context);
    }
}

