/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.input;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.input.GuiBaseTextElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.values.ValueDouble;
import mchorse.mclib.config.values.ValueFloat;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.math.MathBuilder;
import mchorse.mclib.utils.ColorUtils;
import mchorse.mclib.utils.MathUtils;
import mchorse.mclib.utils.Timer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiTrackpadElement
extends GuiBaseTextElement {
    public static final DecimalFormat FORMAT = new DecimalFormat("#.###");
    public Consumer<Double> callback;
    public double value;
    public double strong = 1.0;
    public double normal = 0.25;
    public double weak = 0.05f;
    public double increment = 1.0;
    public double min = Double.NEGATIVE_INFINITY;
    public double max = Double.POSITIVE_INFINITY;
    public boolean integer;
    private boolean dragging;
    private int shiftX;
    private int initialX;
    private int initialY;
    private double lastValue;
    private Timer changed = new Timer(30L);
    private long time;
    private Area plusOne = new Area();
    private Area minusOne = new Area();

    public GuiTrackpadElement(Minecraft mc, ValueInt value) {
        this(mc, value, null);
    }

    public GuiTrackpadElement(Minecraft mc, ValueInt value, Consumer<Double> callback) {
        this(mc, callback == null ? v -> value.set(v.intValue()) : v -> {
            value.set(v.intValue());
            callback.accept((Double)v);
        });
        this.limit(value.min, value.max, true);
        this.setValue(value.get());
        this.tooltip(IKey.lang(value.getTooltipKey()));
    }

    public GuiTrackpadElement(Minecraft mc, ValueFloat value) {
        this(mc, value, null);
    }

    public GuiTrackpadElement(Minecraft mc, ValueFloat value, Consumer<Double> callback) {
        this(mc, callback == null ? v -> value.set(v.floatValue()) : v -> {
            value.set(v.floatValue());
            callback.accept((Double)v);
        });
        this.limit(value.min, value.max);
        this.setValue(value.get());
        this.tooltip(IKey.lang(value.getTooltipKey()));
    }

    public GuiTrackpadElement(Minecraft mc, ValueDouble value) {
        this(mc, value, null);
    }

    public GuiTrackpadElement(Minecraft mc, ValueDouble value, Consumer<Double> callback) {
        this(mc, callback == null ? value::set : v -> {
            value.set((double)v);
            callback.accept((Double)v);
        });
        this.limit((float)value.min, (float)value.max);
        this.setValue((float)value.get());
        this.tooltip(IKey.lang(value.getTooltipKey()));
    }

    public GuiTrackpadElement(Minecraft mc, Consumer<Double> callback) {
        super(mc);
        this.callback = callback;
        this.field.func_146185_a(false);
        this.setValue(0.0);
        this.flex().h(20);
    }

    public GuiTrackpadElement max(double max) {
        this.max = max;
        return this;
    }

    public GuiTrackpadElement limit(double min) {
        this.min = min;
        return this;
    }

    public GuiTrackpadElement limit(double min, double max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public GuiTrackpadElement limit(double min, double max, boolean integer) {
        this.integer = integer;
        return this.limit(min, max);
    }

    public GuiTrackpadElement integer() {
        this.integer = true;
        return this;
    }

    public GuiTrackpadElement increment(double increment) {
        this.increment = increment;
        return this;
    }

    public GuiTrackpadElement values(double normal) {
        this.normal = normal;
        this.weak = normal / 5.0;
        this.strong = normal * 5.0;
        return this;
    }

    public GuiTrackpadElement values(double normal, double weak, double strong) {
        this.normal = normal;
        this.weak = weak;
        this.strong = strong;
        return this;
    }

    public GuiTrackpadElement degrees() {
        return this.increment(15.0).values(1.0, 0.1, 5.0);
    }

    public GuiTrackpadElement block() {
        return this.increment(0.0625).values(0.03125, 0.0078125, 0.5);
    }

    public GuiTrackpadElement metric() {
        return this.values(0.1, 0.01, 1.0);
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean isDraggingTime() {
        return this.isDragging() && System.currentTimeMillis() - this.time > 150L;
    }

    public void setValue(double value) {
        value = (float)Math.round(value * 1000.0) / 1000.0f;
        value = MathUtils.clamp(value, this.min, this.max);
        if (this.integer) {
            value = (int)value;
        }
        this.value = value;
        this.field.func_146180_a(this.integer ? String.valueOf((int)value) : FORMAT.format(value));
        this.field.func_146196_d();
    }

    public void setValueAndNotify(double value) {
        this.setValue(value);
        if (this.callback != null) {
            this.callback.accept(value);
        }
    }

    @Override
    public void unfocus(GuiContext context) {
        super.unfocus(context);
        this.setValue(this.value);
    }

    @Override
    public void resize() {
        super.resize();
        this.plusOne.copy(this.area);
        this.minusOne.copy(this.area);
        this.minusOne.w = 20;
        this.plusOne.w = 20;
        this.plusOne.x = this.area.ex() - 20;
    }

    @Override
    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context)) {
            return true;
        }
        if (context.mouseButton == 0) {
            boolean wasFocused = this.field.func_146206_l();
            this.field.func_146192_a(context.mouseX, context.mouseY, context.mouseButton);
            if (wasFocused != this.field.func_146206_l()) {
                context.focus(wasFocused ? null : this);
            }
            if (this.area.isInside(context)) {
                if (Keyboard.isKeyDown((int)29)) {
                    this.setValueAndNotify(Math.round(this.value));
                    return true;
                }
                if (!(this.field.func_146206_l() || this.plusOne.isInside(context) || this.minusOne.isInside(context))) {
                    context.focus(this);
                }
                this.dragging = true;
                this.initialX = context.mouseX;
                this.initialY = context.mouseY;
                this.lastValue = this.value;
                this.time = System.currentTimeMillis();
            }
        }
        return context.mouseButton == 0 && this.area.isInside(context);
    }

    @Override
    public void mouseReleased(GuiContext context) {
        if (this.dragging && !this.isDraggingTime() && context.mouseButton == 0 && McLib.enableTrackpadIncrements.get()) {
            if (this.plusOne.isInside(context)) {
                this.setValueAndNotify(this.value + this.increment);
            } else if (this.minusOne.isInside(context)) {
                this.setValueAndNotify(this.value - this.increment);
            }
        }
        this.dragging = false;
        this.shiftX = 0;
        super.mouseReleased(context);
    }

    @Override
    public boolean keyTyped(GuiContext context) {
        if (super.keyTyped(context)) {
            return true;
        }
        if (this.isFocused()) {
            if (context.keyCode == 200) {
                this.setValueAndNotify(this.value + this.getValueModifier());
                return true;
            }
            if (context.keyCode == 208) {
                this.setValueAndNotify(this.value - this.getValueModifier());
                return true;
            }
            if (context.keyCode == 15) {
                context.focus(this, -1, GuiScreen.func_146272_n() ? -1 : 1);
                return true;
            }
            if (context.keyCode == 1) {
                context.unfocus();
                return true;
            }
            if (context.keyCode == 28 && GuiScreen.func_175283_s()) {
                try {
                    MathBuilder builder = new MathBuilder();
                    this.setValueAndNotify(builder.parse(this.field.func_146179_b()).get());
                }
                catch (Exception builder) {
                    // empty catch block
                }
            }
        }
        String old = this.field.func_146179_b();
        boolean result = this.field.func_146201_a(context.typedChar, context.keyCode);
        String text = this.field.func_146179_b();
        if (this.field.func_146206_l() && !text.equals(old)) {
            try {
                double d = this.value = text.isEmpty() ? 0.0 : (double)Float.parseFloat(text);
                if (this.callback != null) {
                    this.callback.accept(this.value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void draw(GuiContext context) {
        boolean minus;
        int x = this.area.x;
        int y = this.area.y;
        int w = this.area.w;
        int h = this.area.h;
        int padding = McLib.enableBorders.get() ? 1 : 0;
        this.area.draw(-16777216);
        boolean dragging = this.isDraggingTime();
        boolean plus = !dragging && this.plusOne.isInside(context);
        boolean bl = minus = !dragging && this.minusOne.isInside(context);
        if (dragging) {
            int color = McLib.primaryColor.get();
            int fx = MathUtils.clamp(context.mouseX, this.area.x + padding, this.area.ex() - padding);
            Gui.func_73734_a((int)Math.min(fx, this.initialX), (int)(this.area.y + padding), (int)Math.max(fx, this.initialX), (int)(this.area.ey() - padding), (int)(-16777216 + color));
        }
        if (McLib.enableTrackpadIncrements.get()) {
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            this.plusOne.draw(plus ? 0x22FFFFFF : 0xAFFFFFF, padding);
            this.minusOne.draw(minus ? 0x22FFFFFF : 0xAFFFFFF, padding);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            ColorUtils.bindColor(minus ? -1 : -2130706433);
            Icons.MOVE_LEFT.render(x + 5, y + (h - 16) / 2);
            ColorUtils.bindColor(plus ? -1 : -2130706433);
            Icons.MOVE_RIGHT.render(x + w - 13, y + (h - 16) / 2);
            GlStateManager.func_179084_k();
        }
        int width = MathUtils.clamp(this.font.func_78256_a(this.field.func_146179_b()), 0, w - 16);
        this.field.field_146209_f = this.area.mx(width);
        this.field.field_146210_g = this.area.my() - 4;
        this.field.field_146218_h = width + 6;
        this.field.field_146219_i = 9;
        this.field.func_146194_f();
        if (dragging) {
            double factor = Math.ceil((double)this.mc.field_71443_c / (double)context.screen.field_146294_l);
            int mouseX = context.globalX(context.mouseX);
            if (this.changed.isTime()) {
                int border = 5;
                int borderPadding = 6;
                boolean stop = false;
                if (mouseX <= 5) {
                    Mouse.setCursorPosition((int)(this.mc.field_71443_c - (int)(factor * 6.0)), (int)Mouse.getY());
                    this.shiftX -= context.screen.field_146294_l - 12;
                    this.changed.mark();
                    stop = true;
                } else if (mouseX >= context.screen.field_146294_l - 5) {
                    Mouse.setCursorPosition((int)((int)(factor * 6.0)), (int)Mouse.getY());
                    this.shiftX += context.screen.field_146294_l - 12;
                    this.changed.mark();
                    stop = true;
                }
                if (!stop) {
                    int dx;
                    if (this.isFocused()) {
                        context.unfocus();
                    }
                    if ((dx = this.shiftX + context.mouseX - this.initialX) != 0) {
                        double value = this.getValueModifier();
                        double diff = (double)(Math.abs(dx) - 3) * value;
                        double newValue = this.lastValue + (dx < 0 ? -diff : diff);
                        double d = newValue = diff < 0.0 ? this.lastValue : (double)((float)Math.round(newValue * 1000.0) / 1000.0f);
                        if (this.value != newValue) {
                            this.setValueAndNotify(MathUtils.clamp(newValue, this.min, this.max));
                        }
                    }
                }
            }
            GuiDraw.drawOutlineCenter(this.initialX, this.initialY, 4, -1);
        }
        GuiDraw.drawLockedArea(this);
        super.draw(context);
    }

    protected double getValueModifier() {
        double value = this.normal;
        if (Keyboard.isKeyDown((int)42)) {
            value = this.strong;
        } else if (Keyboard.isKeyDown((int)29)) {
            value = this.increment;
        } else if (Keyboard.isKeyDown((int)56)) {
            value = this.weak;
        }
        return value;
    }

    static {
        FORMAT.setRoundingMode(RoundingMode.HALF_EVEN);
    }
}

