/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.context;

import java.util.List;
import java.util.function.Consumer;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Icon;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public class GuiSimpleContextMenu
extends GuiContextMenu {
    public GuiListElement<Action> actions;

    public GuiSimpleContextMenu(Minecraft mc) {
        super(mc);
        this.actions = new GuiActionListElement(mc, action -> {
            if (((Action)action.get((int)0)).runnable != null) {
                ((Action)action.get((int)0)).runnable.run();
            }
            this.removeFromParent();
        });
        this.actions.flex().relative(this).w(1.0f, 0).h(1.0f, 0);
        this.add((IGuiElement)this.actions);
    }

    public GuiSimpleContextMenu action(IKey label, Runnable runnable) {
        return this.action(Icons.NONE, label, runnable);
    }

    public GuiSimpleContextMenu action(Icon icon, IKey label, Runnable runnable) {
        if (icon == null || label == null) {
            return this;
        }
        this.actions.add(new Action(icon, label, runnable));
        return this;
    }

    @Override
    public void setMouse(GuiContext context) {
        int w = 100;
        for (Action action : this.actions.getList()) {
            w = Math.max(action.getWidth(this.font), w);
        }
        this.flex().set(context.mouseX(), context.mouseY(), w, this.actions.scroll.scrollSize).bounds(context.screen.root, 5);
    }

    public static class Action {
        public Icon icon;
        public IKey label;
        public Runnable runnable;

        public Action(Icon icon, IKey label, Runnable runnable) {
            this.icon = icon;
            this.label = label;
            this.runnable = runnable;
        }

        public int getWidth(FontRenderer font) {
            return 28 + font.func_78256_a(this.label.get());
        }
    }

    public static class GuiActionListElement
    extends GuiListElement<Action> {
        public GuiActionListElement(Minecraft mc, Consumer<List<Action>> callback) {
            super(mc, callback);
            this.scroll.scrollItemSize = 20;
        }

        @Override
        public void drawListElement(Action element, int i, int x, int y, boolean hover, boolean selected) {
            int h = this.scroll.scrollItemSize;
            if (hover) {
                Gui.func_73734_a((int)x, (int)y, (int)(x + this.scroll.w), (int)(y + this.scroll.scrollItemSize), (int)(-2013265920 + McLib.primaryColor.get()));
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            element.icon.render(x + 2, y + h / 2, 0.0f, 0.5f);
            this.font.func_78276_b(element.label.get(), x + 22, y + (h - this.font.field_78288_b) / 2 + 1, 0xFFFFFF);
        }
    }
}

