/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.events.RenderOverlayEvent;
import mchorse.mclib.utils.Interpolation;
import mchorse.mclib.utils.Keys;
import mchorse.mclib.utils.MatrixUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class InputRenderer {
    public static boolean disabledForFrame = false;
    private List<PressedKey> pressedKeys = new ArrayList<PressedKey>();
    private float lastQX = 1.0f;
    private float lastQY = 0.0f;
    private float currentQX = 0.0f;
    private float currentQY = 1.0f;
    private long lastDWheelTime;
    private int lastDWheelScroll;

    public static void disable() {
        disabledForFrame = true;
    }

    public static void preRenderOverlay() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution resolution = new ScaledResolution(mc);
        InputRenderer.setupOrthoProjection(resolution);
        McLib.EVENT_BUS.post((Event)new RenderOverlayEvent.Pre(mc, resolution));
    }

    public static void postRenderOverlay() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution resolution = new ScaledResolution(mc);
        InputRenderer.setupOrthoProjection(resolution);
        McLib.EVENT_BUS.post((Event)new RenderOverlayEvent.Post(mc, resolution));
    }

    private static void setupOrthoProjection(ScaledResolution resolution) {
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)resolution.func_78327_c(), (double)resolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    @SubscribeEvent
    public void onDrawEvent(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (disabledForFrame) {
            disabledForFrame = false;
            return;
        }
        int x = event.getMouseX();
        int y = event.getMouseY();
        this.renderMouse(x, y);
        if (McLib.enableKeystrokeRendering.get()) {
            this.renderKeys(event.getGui(), x, y);
        }
    }

    private void renderMouse(int x, int y) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1000.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        if (McLib.enableCursorRendering.get()) {
            Icons.CURSOR.render(x, y);
        }
        if (McLib.enableMouseButtonRendering.get()) {
            boolean isScrolling;
            boolean left = Mouse.isButtonDown((int)0);
            boolean right = Mouse.isButtonDown((int)1);
            boolean middle = Mouse.isButtonDown((int)2);
            int scroll = Mouse.getDWheel();
            long current = System.currentTimeMillis();
            boolean bl = isScrolling = scroll != 0 || current - this.lastDWheelTime < 500L;
            if (scroll != 0) {
                this.lastDWheelTime = current;
                this.lastDWheelScroll = scroll;
            }
            if (scroll == 0 && isScrolling) {
                scroll = this.lastDWheelScroll;
            }
            x += 16;
            y += 2;
            if (left || right || middle || isScrolling) {
                Gui.func_73734_a((int)(x - 1), (int)y, (int)(x + 13), (int)(y + 16), (int)-16777216);
                Gui.func_73734_a((int)x, (int)(y - 1), (int)(x + 12), (int)(y + 17), (int)-16777216);
                Gui.func_73734_a((int)x, (int)(y + 1), (int)(x + 12), (int)(y + 15), (int)-1);
                Gui.func_73734_a((int)(x + 1), (int)y, (int)(x + 11), (int)(y + 1), (int)-1);
                Gui.func_73734_a((int)(x + 1), (int)(y + 15), (int)(x + 11), (int)(y + 16), (int)-1);
                Gui.func_73734_a((int)x, (int)(y + 7), (int)(x + 12), (int)(y + 8), (int)-1118482);
                if (left) {
                    Gui.func_73734_a((int)(x + 1), (int)y, (int)(x + 6), (int)(y + 7), (int)-3355444);
                    Gui.func_73734_a((int)x, (int)(y + 1), (int)(x + 1), (int)(y + 7), (int)-5592406);
                }
                if (right) {
                    Gui.func_73734_a((int)(x + 6), (int)y, (int)(x + 11), (int)(y + 7), (int)-5592406);
                    Gui.func_73734_a((int)(x + 11), (int)(y + 1), (int)(x + 12), (int)(y + 7), (int)-7829368);
                }
                if (middle || isScrolling) {
                    int offset = 0;
                    if (isScrolling) {
                        offset = scroll < 0 ? 1 : -1;
                    }
                    Gui.func_73734_a((int)(x + 4), (int)y, (int)(x + 8), (int)(y + 6), (int)0x20000000);
                    Gui.func_73734_a((int)(x + 5), (int)(y + 1 + offset), (int)(x + 7), (int)(y + 5 + offset), (int)-12303292);
                    Gui.func_73734_a((int)(x + 5), (int)(y + 4 + offset), (int)(x + 7), (int)(y + 5 + offset), (int)-13421773);
                }
            }
            if (isScrolling) {
                int color = McLib.primaryColor.get();
                GuiDraw.drawDropShadow(x += 16, y, x + 4, y + 16, 2, -2013265920 + color, color);
                Gui.func_73734_a((int)x, (int)y, (int)(x + 4), (int)(y + 16), (int)-15658735);
                Gui.func_73734_a((int)(x + 1), (int)y, (int)(x + 3), (int)(y + 15), (int)-14013910);
                int offset = (int)(current % 1000L / 50L % 4L);
                if (scroll >= 0) {
                    offset = 3 - offset;
                }
                for (int i = 0; i < 4; ++i) {
                    Gui.func_73734_a((int)x, (int)(y + offset), (int)(x + 4), (int)(y + offset + 1), (int)-2007673515);
                    y += 4;
                }
            }
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179121_F();
    }

    private void renderKeys(GuiScreen screen, int mouseX, int mouseY) {
        float lqx = Math.round((float)mouseX / (float)screen.field_146294_l);
        float lqy = Math.round((float)mouseY / (float)screen.field_146295_m);
        int mode = McLib.keystrokeMode.get();
        if (lqx == this.currentQX && lqy == this.currentQY) {
            this.currentQX = this.lastQX;
            this.currentQY = this.lastQY;
        }
        if (mode == 1) {
            this.currentQX = 0.0f;
            this.currentQY = 1.0f;
        } else if (mode == 2) {
            this.currentQX = 1.0f;
            this.currentQY = 1.0f;
        } else if (mode == 3) {
            this.currentQX = 1.0f;
            this.currentQY = 0.0f;
        } else if (mode == 4) {
            this.currentQX = 0.0f;
            this.currentQY = 0.0f;
        }
        float qx = this.currentQX;
        float qy = this.currentQY;
        int fy = qy > 0.5f ? 1 : -1;
        int offset = McLib.keystrokeOffset.get();
        int mx = offset + (int)(qx * (float)(screen.field_146294_l - offset * 2));
        int my = offset + (int)(qy * (float)(screen.field_146295_m - 20 - offset * 2));
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        Iterator<PressedKey> it = this.pressedKeys.iterator();
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        while (it.hasNext()) {
            PressedKey key = it.next();
            if (key.expired()) {
                it.remove();
                continue;
            }
            int x = mx + (qx < 0.5f ? key.x : -(key.x + key.width + 10));
            int y = my + (int)(Interpolation.EXP_INOUT.interpolate(0.0f, 1.0f, key.getFactor()) * 50.0f * (float)fy) + (key.i % 2 == 0 ? -1 : 0);
            GuiDraw.drawDropShadow(x, y, x + 10 + key.width, y + 20, 4, 0x44000000, 0);
            Gui.func_73734_a((int)x, (int)y, (int)(x + 10 + key.width), (int)(y + 20), (int)(-16777216 + McLib.primaryColor.get()));
            font.func_175063_a(key.getLabel(), (float)(x + 5), (float)(y + 6), 0xFFFFFF);
        }
        this.lastQX = lqx;
        this.lastQY = lqy;
    }

    @SubscribeEvent
    public void onKeyPressedInGUI(GuiScreenEvent.KeyboardInputEvent.Post event) {
        boolean inputFocused;
        boolean bl = inputFocused = GuiBase.getCurrent() == null || GuiBase.getCurrent().activeElement == null;
        if (Keyboard.getEventKeyState() && inputFocused) {
            int key;
            int n = key = Keyboard.getEventKey() == 0 ? Keyboard.getEventCharacter() + 256 : Keyboard.getEventKey();
            if (key >= 256 || key < 0) {
                return;
            }
            PressedKey last = null;
            int offset = -1000;
            for (PressedKey pressed : this.pressedKeys) {
                if (pressed.key == key) {
                    offset = pressed.increment();
                } else if (offset != -1000) {
                    pressed.x += offset;
                }
                last = pressed;
            }
            if (offset != -1000) {
                return;
            }
            offset = McLib.keystrokeOffset.get();
            int x = last == null ? 0 : last.x + last.width + 5;
            PressedKey newKey = new PressedKey(key, x);
            if (newKey.x + newKey.width + offset > event.getGui().field_146294_l - offset * 2) {
                newKey.x = 0;
            }
            this.pressedKeys.add(newKey);
        }
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        MatrixUtils.releaseMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public static class PressedKey {
        public static int INDEX = 0;
        public int key;
        public long time;
        public int x;
        public String name;
        public int width;
        public int i;
        public int times = 1;

        public PressedKey(int key, int x) {
            this.key = key;
            this.time = System.currentTimeMillis();
            this.x = x;
            this.name = Keys.getKeyName(key);
            this.width = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.name);
            this.i = INDEX++;
        }

        public float getFactor() {
            return (float)(System.currentTimeMillis() - this.time - 500L) / 1000.0f;
        }

        public boolean expired() {
            if (Keyboard.isKeyDown((int)this.key)) {
                this.time = System.currentTimeMillis();
            }
            return System.currentTimeMillis() - this.time > 1500L;
        }

        public String getLabel() {
            if (this.times > 1) {
                return this.name + " (" + this.times + ")";
            }
            return this.name;
        }

        public int increment() {
            int lastWidth = this.width;
            ++this.times;
            this.width = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.getLabel());
            return this.width - lastWidth;
        }
    }
}

