/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.inv.block;

import CoroUtil.difficulty.DifficultyInfoPlayer;
import CoroUtil.difficulty.DynamicDifficulty;
import CoroUtil.forge.CULog;
import com.corosus.inv.InvasionManager;
import com.corosus.inv.InventoryBasicCopy;
import com.corosus.inv.config.ConfigInvasion;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntitySacrifice
extends TileEntity
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_ALL = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private InventoryBasicCopy inventory;
    private DifficultyInfoPlayer difficultyInfoPlayer;
    private String ownerName = "";
    private EntityPlayer player;
    private String inventoryName = "Sacrifice Inventory";
    IItemHandler handlerAll = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public TileEntitySacrifice() {
        this.inventory = new InventoryBasicCopy(this.inventoryName, true, 9);
    }

    public void onLoad() {
        super.onLoad();
        this.difficultyInfoPlayer = new DifficultyInfoPlayer(this.func_174877_v());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            boolean skipped;
            EntityPlayer player;
            if (this.ownerName.equals("") && (player = this.field_145850_b.func_184137_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 128.0, false)) != null) {
                this.ownerName = player.func_70005_c_();
            }
            if (skipped = this.tryToSacrifice()) {
                InvasionManager.skipNextInvasionForPlayer(this.player);
                CULog.dbg((String)("skipped: " + skipped));
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound var1) {
        ItemStackHelper.func_191282_a((NBTTagCompound)var1, this.inventory.inventoryContents);
        var1.func_74778_a("ownerName", this.ownerName);
        return super.func_189515_b(var1);
    }

    public void func_145839_a(NBTTagCompound var1) {
        super.func_145839_a(var1);
        this.ownerName = var1.func_74779_i(this.ownerName);
        ItemStackHelper.func_191283_b((NBTTagCompound)var1, this.inventory.inventoryContents);
    }

    public boolean tryToSacrifice() {
        EntityPlayer player = this.getPlayer();
        return player != null && InvasionManager.canPlayerSkipInvasion(player) && this.spendItem();
    }

    public boolean spendItem() {
        if (this.spendItemImpl(true)) {
            return this.spendItemImpl(false);
        }
        return false;
    }

    public boolean spendItemImpl(boolean dryRun) {
        Item item = Item.func_111206_d((String)ConfigInvasion.Sacrifice_Item_Name);
        EntityPlayer player = this.getPlayer();
        if (player != null) {
            int skipCount = player.getEntityData().func_74762_e(DynamicDifficulty.dataPlayerInvasionSkipCountForMultiplier);
            int amountNeeded = skipCount == 0 ? ConfigInvasion.Sacrifice_CountNeeded : (int)((double)ConfigInvasion.Sacrifice_CountNeeded * ConfigInvasion.Sacrifice_CountNeeded_Multiplier * (double)skipCount);
            if (item != null) {
                for (int i = 0; i < this.inventory.func_70297_j_() && amountNeeded > 0; ++i) {
                    ItemStack stack = this.inventory.func_70301_a(i);
                    if (stack.func_77973_b() != item || ConfigInvasion.Sacrifice_Item_Meta != -1 && stack.func_77960_j() != ConfigInvasion.Sacrifice_Item_Meta) continue;
                    if (stack.func_190916_E() > amountNeeded) {
                        if (!dryRun) {
                            stack.func_190918_g(amountNeeded);
                        }
                        amountNeeded = 0;
                        continue;
                    }
                    amountNeeded -= stack.func_190916_E();
                    if (dryRun) continue;
                    this.inventory.func_70299_a(i, ItemStack.field_190927_a);
                }
            }
            return amountNeeded == 0;
        }
        return false;
    }

    public void onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (InvasionManager.skipNextInvasionForPlayer(playerIn)) {
            playerIn.func_145747_a((ITextComponent)new TextComponentString("Sacrifice received!"));
            if (!playerIn.func_184812_l_()) {
                playerIn.func_70097_a(DamageSource.field_76376_m, 12.0f);
            }
        }
    }

    public InventoryBasicCopy getInventory() {
        return this.inventory;
    }

    public void setInventory(InventoryBasicCopy inventory) {
        this.inventory = inventory;
    }

    public DifficultyInfoPlayer getDifficultyInfoPlayer() {
        return this.difficultyInfoPlayer;
    }

    public void setDifficultyInfoPlayer(DifficultyInfoPlayer difficultyInfoPlayer) {
        this.difficultyInfoPlayer = difficultyInfoPlayer;
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
    }

    public EntityPlayer getPlayer() {
        if (this.player == null) {
            EntityPlayer findPlayer;
            this.player = findPlayer = this.field_145850_b.func_72924_a(this.ownerName);
        }
        return this.player;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory.inventoryContents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory.inventoryContents, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory.inventoryContents, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.inventoryContents.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.inventoryContents.clear();
    }

    public String func_70005_c_() {
        return this.inventoryName;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handlerAll;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS_ALL;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }
}

