/*
 * Decompiled with CFR 0.152.
 */
package com.hancinworld.fw.proxy;

import com.hancinworld.fw.handler.ConfigurationHandler;
import com.hancinworld.fw.handler.DrawScreenEventHandler;
import com.hancinworld.fw.handler.KeyInputEventHandler;
import com.hancinworld.fw.proxy.CommonProxy;
import com.hancinworld.fw.utility.LogHelper;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.SplashProgress;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public class ClientProxy
extends CommonProxy {
    private final Minecraft client = Minecraft.func_71410_x();
    private Rectangle _savedWindowedBounds;
    public static boolean fullscreen;
    public static KeyBinding fullscreenKeyBinding;
    public DrawScreenEventHandler dsHandler;
    public static KeyBinding ignoreKeyBinding;

    @Override
    public void registerKeyBindings() {
        if (fullscreenKeyBinding == null && ConfigurationHandler.instance().isFullscreenWindowedEnabled()) {
            fullscreenKeyBinding = this.client.field_71474_y.field_152395_am;
            this.client.field_71474_y.field_152395_am = ignoreKeyBinding;
        } else if (fullscreenKeyBinding != null && !ConfigurationHandler.instance().isFullscreenWindowedEnabled()) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71474_y.field_152395_am = fullscreenKeyBinding;
            fullscreenKeyBinding = null;
            if (fullscreen) {
                mc.field_71431_Q = false;
                mc.func_71352_k();
            }
        }
    }

    @Override
    public void subscribeEvents(File configurationFile) {
        ConfigurationHandler.instance().init(configurationFile);
        FMLCommonHandler.instance().bus().register((Object)ConfigurationHandler.instance());
        FMLCommonHandler.instance().bus().register((Object)new KeyInputEventHandler());
        this.dsHandler = new DrawScreenEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)this.dsHandler);
    }

    private Rectangle findCurrentScreenDimensionsAndPosition(int x, int y) {
        GraphicsDevice[] screens;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice dev : screens = env.getScreenDevices()) {
            GraphicsConfiguration displayMode = dev.getDefaultConfiguration();
            Rectangle bounds = displayMode.getBounds();
            if (!bounds.contains(x, y)) continue;
            return bounds;
        }
        return new Rectangle(0, 0, Display.getDesktopDisplayMode().getWidth(), Display.getDesktopDisplayMode().getHeight());
    }

    private Rectangle findScreenDimensionsByID(int monitorID) {
        if (monitorID < 1) {
            return null;
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = env.getScreenDevices();
        if (screens == null || screens.length == 0 || screens.length < monitorID) {
            return null;
        }
        return screens[monitorID - 1].getDefaultConfiguration().getBounds();
    }

    private Rectangle getAppropriateScreenBounds(Rectangle currentCoordinates, int desiredMonitor) {
        Rectangle screenBounds;
        Point centerCoordinates = new Point((int)(currentCoordinates.getMinX() + currentCoordinates.getWidth() / 2.0), (int)(currentCoordinates.getMinY() + currentCoordinates.getHeight() / 2.0));
        ConfigurationHandler configuration = ConfigurationHandler.instance();
        if (configuration.areAdvancedFeaturesEnabled() && configuration.isOnlyRemoveDecorations()) {
            screenBounds = currentCoordinates;
        } else if (configuration.areAdvancedFeaturesEnabled() && configuration.isCustomFullscreenDimensions() && configuration.getCustomFullscreenDimensionsH() > 256 && configuration.getCustomFullscreenDimensionsW() > 256) {
            Rectangle actualScreenBounds;
            screenBounds = new Rectangle(configuration.getCustomFullscreenDimensionsX(), configuration.getCustomFullscreenDimensionsY(), configuration.getCustomFullscreenDimensionsW(), configuration.getCustomFullscreenDimensionsH());
            if (desiredMonitor > 0 && (actualScreenBounds = this.findScreenDimensionsByID(desiredMonitor)) != null) {
                screenBounds.setLocation(actualScreenBounds.x + screenBounds.x, actualScreenBounds.y + screenBounds.y);
            }
        } else if (desiredMonitor < 0 || desiredMonitor == 0) {
            screenBounds = this.findCurrentScreenDimensionsAndPosition((int)centerCoordinates.getX(), (int)centerCoordinates.getY());
        } else {
            screenBounds = this.findScreenDimensionsByID(desiredMonitor);
            if (screenBounds == null) {
                screenBounds = this.findCurrentScreenDimensionsAndPosition((int)centerCoordinates.getX(), (int)centerCoordinates.getY());
            }
        }
        return screenBounds;
    }

    @Override
    public void toggleFullScreen(boolean goFullScreen) {
        this.toggleFullScreen(goFullScreen, ConfigurationHandler.instance().getFullscreenMonitor());
    }

    @Override
    public void toggleFullScreen(boolean goFullScreen, int desiredMonitor) {
        Rectangle newBounds;
        String expectedState;
        if (System.getProperty("org.lwjgl.opengl.Window.undecorated") == null) {
            System.setProperty("org.lwjgl.opengl.Window.undecorated", "false");
        }
        if (Display.isFullscreen()) {
            fullscreen = true;
        }
        String string = expectedState = goFullScreen ? "true" : "false";
        if (fullscreen == goFullScreen && !Display.isFullscreen() && System.getProperty("org.lwjgl.opengl.Window.undecorated") == expectedState) {
            return;
        }
        Rectangle currentCoordinates = new Rectangle(Display.getX(), Display.getY(), Display.getWidth(), Display.getHeight());
        if (goFullScreen && !Display.isFullscreen()) {
            this._savedWindowedBounds = currentCoordinates;
        }
        System.setProperty("org.lwjgl.opengl.Window.undecorated", expectedState);
        Rectangle screenBounds = this.getAppropriateScreenBounds(currentCoordinates, desiredMonitor);
        Rectangle rectangle = newBounds = goFullScreen ? screenBounds : this._savedWindowedBounds;
        if (newBounds == null) {
            newBounds = screenBounds;
        }
        if (!goFullScreen && !fullscreen) {
            newBounds = currentCoordinates;
            this._savedWindowedBounds = currentCoordinates;
        }
        try {
            this.client.field_71431_Q = fullscreen = goFullScreen;
            if (this.client.field_71474_y.field_74353_u != fullscreen) {
                this.client.field_71474_y.field_74353_u = fullscreen;
                this.client.field_71474_y.func_74303_b();
            }
            Display.setFullscreen((boolean)false);
            Display.setResizable((!goFullScreen ? 1 : 0) != 0);
            Display.setDisplayMode((DisplayMode)new DisplayMode((int)newBounds.getWidth(), (int)newBounds.getHeight()));
            Display.setLocation((int)newBounds.x, (int)newBounds.y);
            this.client.func_71370_a((int)newBounds.getWidth(), (int)newBounds.getHeight());
            Display.setVSyncEnabled((boolean)this.client.field_71474_y.field_74352_v);
            this.client.func_175601_h();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void performStartupChecks() {
        if (!ConfigurationHandler.instance().isFullscreenWindowedEnabled()) {
            return;
        }
        if (ConfigurationHandler.instance().isMaximumCompatibilityEnabled()) {
            this.dsHandler.setInitialFullscreen(this.client.field_71474_y.field_74353_u, ConfigurationHandler.instance().getFullscreenMonitor());
        } else {
            try {
                SplashProgress.pause();
                this.toggleFullScreen(this.client.field_71474_y.field_74353_u, ConfigurationHandler.instance().getFullscreenMonitor());
                SplashProgress.resume();
            }
            catch (NoClassDefFoundError e) {
                LogHelper.warn("Error while doing startup checks, are you using an old version of Forge ? " + e);
                this.toggleFullScreen(this.client.field_71474_y.field_74353_u, ConfigurationHandler.instance().getFullscreenMonitor());
            }
        }
    }

    static {
        ignoreKeyBinding = new KeyBinding("key.fullscreenwindowed.unused", 0, "key.categories.misc");
    }
}

