/*
 * Decompiled with CFR 0.152.
 */
package ocean.inventoryprotection.common.event;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ocean.inventoryprotection.common.ModItems;
import ocean.inventoryprotection.common.config.ApplicationConfig;

@Mod.EventBusSubscriber(modid="inventoryprotection")
public class ModEvents {
    private static final String APPLICATION_NAME = "InventoryProtection_playerInventoryDrops";
    private static final String DROP_SIZE = "dropSize";
    private static final String DROP_PREFIX = "dropPrefix";
    private static final String DROP_LEVEL_POINT = "dropLevelPoint";

    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        List drops;
        if (event.getEntity() instanceof PlayerEntity && ModEvents.container((Item)ModItems.PROTECTOR.get(), event.getDrops()) && (drops = event.getDrops().stream().map(res -> {
            if (!res.func_92059_d().func_190926_b()) {
                return res;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList())).size() > 0) {
            event.getDrops().removeAll(drops);
            CompoundNBT inventorySize = new CompoundNBT();
            for (int i = 0; i < drops.size(); ++i) {
                ItemStack stack = ((ItemEntity)drops.get(i)).func_92059_d();
                CompoundNBT tagItem = stack.func_77955_b(new CompoundNBT());
                inventorySize.func_218657_a(DROP_PREFIX + i, (INBT)tagItem);
            }
            CompoundNBT data = event.getEntity().getPersistentData();
            if (!data.func_74764_b("PlayerPersisted")) {
                data.func_218657_a("PlayerPersisted", (INBT)new CompoundNBT());
            }
            inventorySize.func_74768_a(DROP_SIZE, drops.size());
            inventorySize.func_74768_a(DROP_LEVEL_POINT, ((PlayerEntity)event.getEntity()).field_71067_cb);
            CompoundNBT persist = data.func_74775_l("PlayerPersisted");
            persist.func_218657_a(APPLICATION_NAME, (INBT)inventorySize);
        }
    }

    @SubscribeEvent
    public static void onLivingExperienceDropEvent(LivingExperienceDropEvent event) {
        if (((Boolean)ApplicationConfig.LEVEL.get()).booleanValue() && event.getEntity().getPersistentData().func_74764_b("PlayerPersisted")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Entity entity = event.getEntity();
        PlayerEntity player = (PlayerEntity)entity;
        CompoundNBT data = player.getPersistentData();
        if (data.func_74764_b("PlayerPersisted")) {
            CompoundNBT inventoryIndex = data.func_74775_l("PlayerPersisted");
            CompoundNBT allDrops = inventoryIndex.func_74775_l(APPLICATION_NAME);
            int count = allDrops.func_74762_e(DROP_SIZE);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    CompoundNBT item = allDrops.func_74775_l(DROP_PREFIX + i);
                    ItemStack stack = ItemStack.func_199557_a((CompoundNBT)item);
                    if (stack.func_190926_b()) continue;
                    ItemStack copy = stack.func_77946_l();
                    if (copy.func_77973_b() == ModItems.PROTECTOR.get()) {
                        copy.func_190918_g(1);
                    }
                    if (copy.func_77973_b() instanceof ArmorItem || copy.func_77973_b() instanceof ShieldItem) {
                        EquipmentSlotType equipmentSlotType = MobEntity.func_184640_d((ItemStack)copy);
                        player.func_184201_a(equipmentSlotType, copy.func_77946_l());
                        continue;
                    }
                    if (player.field_71071_by.func_70441_a(copy)) continue;
                    player.func_71019_a(copy, true);
                }
                if (((Boolean)ApplicationConfig.LEVEL.get()).booleanValue()) {
                    player.func_195068_e(allDrops.func_74762_e(DROP_LEVEL_POINT));
                }
                player.func_145747_a((ITextComponent)new StringTextComponent((String)ApplicationConfig.MESSAGE.get()), player.func_110124_au());
            }
            inventoryIndex.func_82580_o(APPLICATION_NAME);
        }
    }

    public static boolean container(Item item, Collection<ItemEntity> itemEntities) {
        for (ItemEntity itemEntity : itemEntities) {
            if (itemEntity.func_92059_d().func_77973_b() != item) continue;
            return true;
        }
        return false;
    }
}

