/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.entity.stats;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import uk.joshiejack.husbandry.Husbandry;
import uk.joshiejack.husbandry.api.IMobStats;
import uk.joshiejack.husbandry.api.trait.IBiHourlyTrait;
import uk.joshiejack.husbandry.entity.stats.CapabilityStatsHandler;
import uk.joshiejack.husbandry.entity.stats.MobStats;
import uk.joshiejack.husbandry.entity.traits.TraitType;
import uk.joshiejack.penguinlib.events.NewDayEvent;

@Mod.EventBusSubscriber(modid="husbandry")
public class MobStatsTicker {
    private static final Multimap<RegistryKey<World>, MobStats<?>> stats = HashMultimap.create();

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof World && !event.getWorld().func_201670_d()) {
            stats.get((Object)((World)event.getWorld()).func_234923_W_()).clear();
        }
    }

    @SubscribeEvent
    public static void onNewDay(NewDayEvent event) {
        try {
            Lists.newArrayList((Iterable)stats.get((Object)event.getWorld().func_234923_W_())).stream().filter(s -> s.entity.func_70089_S()).forEach(MobStats::onNewDay);
        }
        catch (Exception ex) {
            Husbandry.LOGGER.warn("Husbandry encountered an issue when ticking animals for the day... Try not to worry.");
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.world.func_82737_E() % 2000L == 0L) {
            try {
                Lists.newArrayList((Iterable)MobStatsTicker.stats.get((Object)event.world.func_234923_W_())).stream().filter(s -> s.entity.func_70089_S()).forEach(stats -> {
                    List<IBiHourlyTrait> traits = stats.getTraits(TraitType.BI_HOURLY);
                    traits.forEach(trait -> trait.onBihourlyTick((IMobStats<?>)stats));
                });
            }
            catch (Exception ex) {
                Husbandry.LOGGER.warn("Husbandry encountered an issue when ticking animals every two hours... No reason to be concerned!");
            }
        }
    }

    private static void run(Entity entity, Consumer<MobStats<?>> consumer) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        LazyOptional stats = entity.getCapability(CapabilityStatsHandler.MOB_STATS_CAPABILITY);
        if (!stats.isPresent() || !stats.resolve().isPresent()) {
            return;
        }
        consumer.accept((MobStats<?>)stats.resolve().get());
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        MobStatsTicker.run(event.getEntity(), ms -> stats.get((Object)event.getWorld().func_234923_W_()).add(ms));
    }

    @SubscribeEvent
    public static void onEntityLeaveWorld(EntityLeaveWorldEvent event) {
        MobStatsTicker.run(event.getEntity(), ms -> stats.get((Object)event.getWorld().func_234923_W_()).remove(ms));
    }
}

