/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.entity.stats;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import uk.joshiejack.husbandry.Husbandry;
import uk.joshiejack.husbandry.api.IMobStats;
import uk.joshiejack.husbandry.api.trait.IBiHourlyTrait;
import uk.joshiejack.husbandry.api.trait.IDataTrait;
import uk.joshiejack.husbandry.api.trait.IIconTrait;
import uk.joshiejack.husbandry.api.trait.IInitTrait;
import uk.joshiejack.husbandry.api.trait.IInteractiveTrait;
import uk.joshiejack.husbandry.api.trait.IJoinWorldTrait;
import uk.joshiejack.husbandry.api.trait.IMobTrait;
import uk.joshiejack.husbandry.api.trait.INewDayTrait;
import uk.joshiejack.husbandry.api.trait.IRenderTrait;
import uk.joshiejack.husbandry.entity.ai.AbstractMoveToBlockGoal;
import uk.joshiejack.husbandry.entity.stats.CapabilityStatsHandler;
import uk.joshiejack.husbandry.entity.stats.Species;
import uk.joshiejack.husbandry.entity.traits.TraitType;
import uk.joshiejack.husbandry.entity.traits.product.AbstractMobProductTrait;
import uk.joshiejack.husbandry.entity.traits.product.MoreProductChanceTrait;
import uk.joshiejack.husbandry.network.SendDataPacket;
import uk.joshiejack.husbandry.network.SetHappinessPacket;
import uk.joshiejack.husbandry.network.SpawnHeartsPacket;
import uk.joshiejack.penguinlib.network.PenguinNetwork;
import uk.joshiejack.penguinlib.network.PenguinPacket;
import uk.joshiejack.penguinlib.util.helpers.MathsHelper;
import uk.joshiejack.penguinlib.util.helpers.ReflectionHelper;

public class MobStats<E extends MobEntity>
implements ICapabilityProvider,
INBTSerializable<CompoundNBT>,
IMobStats<E> {
    private static final Lazy<Integer> MAX_RELATIONSHIP = Lazy.of(() -> (Integer)Husbandry.HusbandryConfig.maxHappiness.get());
    private final ListMultimap<TraitType, IMobTrait> traits;
    protected final E entity;
    protected final Species species;
    private int happiness;
    private int happinessDivisor = 5;
    private int hunger;
    private boolean hasProduct = true;
    private int childhood;
    protected boolean loved;
    private boolean eaten;
    private final AbstractMobProductTrait products;
    private final LazyOptional<MobStats<?>> capability;
    private boolean domesticated;

    public MobStats(E entity, @Nonnull Species species) {
        this.entity = entity;
        this.species = species;
        this.traits = LinkedListMultimap.create();
        this.species.getTraits().forEach(trait -> {
            IMobTrait copy;
            IMobTrait iMobTrait = copy = trait instanceof IDataTrait ? (IMobTrait)ReflectionHelper.newInstance(trait.getClass()) : trait;
            if (copy instanceof IJoinWorldTrait) {
                this.traits.get((Object)TraitType.ON_JOIN).add(copy);
            }
            if (copy instanceof IInteractiveTrait) {
                this.traits.get((Object)TraitType.ACTION).add(copy);
            }
            if (copy instanceof IBiHourlyTrait) {
                this.traits.get((Object)TraitType.BI_HOURLY).add(copy);
            }
            if (copy instanceof IDataTrait) {
                this.traits.get((Object)TraitType.DATA).add(copy);
            }
            if (copy instanceof INewDayTrait) {
                this.traits.get((Object)TraitType.NEW_DAY).add(copy);
            }
            if (copy instanceof IRenderTrait) {
                this.traits.get((Object)TraitType.RENDER).add(copy);
            }
            if (copy instanceof IInitTrait) {
                this.traits.get((Object)TraitType.INIT).add(copy);
            }
            if (copy instanceof IIconTrait) {
                this.traits.get((Object)TraitType.ICON).add(copy);
            }
        });
        this.traits.get((Object)TraitType.INIT).forEach(trait -> ((IInitTrait)trait).initTrait(this));
        this.products = (AbstractMobProductTrait)this.traits.get((Object)TraitType.DATA).stream().filter(t -> t instanceof AbstractMobProductTrait).findFirst().orElse(new MoreProductChanceTrait());
        this.capability = LazyOptional.of(() -> this);
    }

    @Override
    public E getEntity() {
        return this.entity;
    }

    @Override
    public Species getSpecies() {
        return this.species;
    }

    public <T> List<T> getTraits(TraitType type) {
        return this.traits.get((Object)type);
    }

    @Override
    public void resetProduct() {
        this.entity.func_70615_aA();
        this.hasProduct = true;
    }

    public void onNewDay() {
        List<INewDayTrait> traits = this.getTraits(TraitType.NEW_DAY);
        traits.forEach(trait -> trait.onNewDay(this));
        if (!this.eaten) {
            ++this.hunger;
            this.decreaseHappiness((Integer)Husbandry.HusbandryConfig.hungerHappinessLoss.get());
        }
        this.loved = false;
        this.eaten = false;
        if (this.entity.func_70631_g_()) {
            ++this.childhood;
            if (this.childhood >= this.species.getDaysToMaturity()) {
                this.entity.func_82227_f(false);
                if (this.entity instanceof SlimeEntity) {
                    try {
                        ObfuscationReflectionHelper.findMethod(SlimeEntity.class, (String)"func_70799_a", (Class[])new Class[]{Integer.TYPE, Boolean.TYPE}).invoke((Object)2, true);
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        // empty catch block
                    }
                }
            }
        }
        ((MobEntity)this.entity).field_70714_bg.func_220888_c().filter(ai -> ai.func_220772_j() instanceof AbstractMoveToBlockGoal).forEach(ai -> ((AbstractMoveToBlockGoal)ai.func_220772_j()).resetRunTimer());
        PenguinNetwork.sendToNearby((PenguinPacket)new SendDataPacket(this.entity.func_145782_y(), this), this.entity);
    }

    @Override
    public boolean isDomesticated() {
        return this.domesticated;
    }

    @Override
    public int getHappiness() {
        return this.happiness;
    }

    @Override
    public void setHappiness(int happiness) {
        this.happiness = happiness;
        if (!((MobEntity)this.entity).field_70170_p.field_72995_K) {
            PenguinNetwork.sendToNearby((PenguinPacket)new SetHappinessPacket(this.entity.func_145782_y(), happiness), this.entity);
        }
    }

    @Override
    public int getHappinessModifier() {
        return this.happinessDivisor;
    }

    @Override
    public void setHappinessModifier(int value) {
        this.happinessDivisor = Math.max(1, Math.min(5, value));
    }

    @Override
    public void decreaseHappiness(int happiness) {
        this.happiness = MathsHelper.constrainToRangeInt((int)(this.happiness - happiness), (int)0, (int)((Integer)MAX_RELATIONSHIP.get() / this.happinessDivisor));
        if (!((MobEntity)this.entity).field_70170_p.field_72995_K) {
            PenguinNetwork.sendToNearby((PenguinPacket)new SpawnHeartsPacket(this.entity.func_145782_y(), false), this.entity);
        }
    }

    @Override
    public void increaseHappiness(int happiness) {
        this.happiness = MathsHelper.constrainToRangeInt((int)(this.happiness + happiness), (int)0, (int)((Integer)MAX_RELATIONSHIP.get() / this.happinessDivisor));
        if (!((MobEntity)this.entity).field_70170_p.field_72995_K) {
            PenguinNetwork.sendToNearby((PenguinPacket)new SpawnHeartsPacket(this.entity.func_145782_y(), true), this.entity);
        }
    }

    public boolean onEntityInteract(PlayerEntity player, Hand hand) {
        this.domesticated = true;
        List traits = this.getTraits(TraitType.ACTION);
        return traits.stream().anyMatch(trait -> trait.onRightClick(this, player, hand));
    }

    @Override
    public void feed() {
        this.hunger = 0;
        this.eaten = true;
    }

    @Override
    public int getHunger() {
        return this.hunger;
    }

    @Override
    public boolean isUnloved() {
        return !this.loved;
    }

    @Override
    public boolean setLoved() {
        this.loved = true;
        this.increaseHappiness((Integer)Husbandry.HusbandryConfig.lovedGain.get());
        return this.loved;
    }

    @Override
    public boolean canProduceProduct() {
        return this.hasProduct && !this.entity.func_70631_g_();
    }

    @Override
    public void setProduced(int amount) {
        this.products.setProduced(this, amount);
        this.hasProduct = false;
    }

    @Override
    public boolean isHungry() {
        return !this.eaten;
    }

    @Override
    public int getMaxHearts() {
        return (5 - (this.happinessDivisor - 1)) * 2;
    }

    @Override
    public int getHearts() {
        return (int)((double)this.happiness / (double)((Integer)MAX_RELATIONSHIP.get()).intValue() * 10.0);
    }

    @Override
    public void setHearts(int hearts) {
        hearts = Math.max(0, Math.min(10, hearts));
        this.happiness = hearts * ((Integer)MAX_RELATIONSHIP.get() / 10);
        if (!((MobEntity)this.entity).field_70170_p.field_72995_K) {
            PenguinNetwork.sendToNearby((PenguinPacket)new SetHappinessPacket(this.entity.func_145782_y(), this.happiness), this.entity);
        }
    }

    @Override
    public int getMaxHappiness() {
        return (Integer)MAX_RELATIONSHIP.get();
    }

    @Nullable
    public static MobStats<?> getStats(Entity entity) {
        LazyOptional stats = entity.getCapability(CapabilityStatsHandler.MOB_STATS_CAPABILITY);
        return stats.isPresent() && stats.resolve().isPresent() ? (MobStats)stats.resolve().get() : null;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityStatsHandler.MOB_STATS_CAPABILITY ? this.capability.cast() : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("Domesticated", this.domesticated);
        tag.func_74768_a("Happiness", this.happiness);
        tag.func_74774_a("HappinessDivisor", (byte)this.happinessDivisor);
        tag.func_74768_a("Hunger", this.hunger);
        tag.func_74768_a("Childhood", this.childhood);
        tag.func_74757_a("HasProduct", this.hasProduct);
        tag.func_74757_a("Loved", this.loved);
        tag.func_74757_a("Eaten", this.eaten);
        List<IDataTrait> data = this.getTraits(TraitType.DATA);
        data.forEach(d -> d.save(tag));
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.domesticated = nbt.func_74767_n("Domesticated");
        this.happiness = nbt.func_74762_e("Happiness");
        this.happinessDivisor = nbt.func_74771_c("HappinessDivisor");
        if (this.happinessDivisor <= 1) {
            this.happinessDivisor = 1;
        }
        if (this.happinessDivisor >= 5) {
            this.happinessDivisor = 5;
        }
        this.hunger = nbt.func_74762_e("Hunger");
        this.childhood = nbt.func_74762_e("Childhood");
        this.hasProduct = nbt.func_74767_n("HasProduct");
        this.loved = nbt.func_74767_n("Loved");
        this.eaten = nbt.func_74767_n("Eaten");
        List<IDataTrait> data = this.getTraits(TraitType.DATA);
        data.forEach(d -> d.load(nbt));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MobStats that = (MobStats)o;
        return Objects.equals(this.entity.func_110124_au(), that.entity.func_110124_au());
    }

    public int hashCode() {
        return Objects.hash(this.entity.func_110124_au());
    }
}

