/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.entity.ai;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import uk.joshiejack.husbandry.api.IMobStats;

public abstract class AbstractMoveToBlockGoal
extends Goal {
    protected final MobEntity entity;
    public final double speedModifier;
    protected int nextStartTick;
    protected int tryTicks;
    private int maxStayTicks;
    protected BlockPos blockPos = BlockPos.field_177992_a;
    private final int searchRange;
    protected int verticalSearchRange;
    protected int verticalSearchStart;
    protected int verticalOffset;
    protected final IMobStats<?> stats;
    protected final Orientation orientation;

    public AbstractMoveToBlockGoal(MobEntity entity, IMobStats<?> stats, Orientation orientation, int searchLength) {
        this.entity = entity;
        this.orientation = orientation;
        this.stats = stats;
        this.speedModifier = 1.0;
        this.searchRange = searchLength;
        this.verticalSearchStart = 0;
        this.verticalSearchRange = 1;
        this.verticalOffset = 0;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    protected boolean isNearDestination() {
        return this.isNearDestination(this.blockPos);
    }

    private boolean isNearDestination(BlockPos pos) {
        switch (this.orientation) {
            case ABOVE: {
                return this.entity.func_233580_cy_().func_218141_a((Vector3i)pos, 1.5);
            }
            case IN: {
                return this.entity.func_233580_cy_().func_218141_a((Vector3i)pos, 1.0);
            }
            case BESIDE: {
                return this.entity.func_233580_cy_().func_218141_a((Vector3i)pos, 2.5);
            }
        }
        return false;
    }

    public void func_75246_d() {
        if (!this.isNearDestination(this.blockPos)) {
            ++this.tryTicks;
            if (this.tryTicks % 40 == 0) {
                this.moveMobToBlock();
            }
        } else {
            --this.tryTicks;
        }
    }

    public void resetRunTimer() {
        this.nextStartTick = 0;
    }

    public boolean func_75250_a() {
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        this.nextStartTick = this.nextStartTick(this.entity);
        return this.findNearestBlock();
    }

    protected int nextStartTick(MobEntity entity) {
        return 200 + entity.func_70681_au().nextInt(200);
    }

    public boolean func_75253_b() {
        return this.tryTicks >= -this.maxStayTicks && this.tryTicks <= 1200 && this.isValidTarget((IWorldReader)this.entity.field_70170_p, this.blockPos);
    }

    public void func_75249_e() {
        this.moveMobToBlock();
        this.tryTicks = 0;
        this.maxStayTicks = this.entity.func_70681_au().nextInt(this.entity.func_70681_au().nextInt(1200) + 1200) + 1200;
    }

    protected void moveMobToBlock() {
        this.entity.func_70661_as().func_75492_a((double)this.blockPos.func_177958_n() + 0.5, (double)(this.blockPos.func_177956_o() + this.verticalOffset), (double)this.blockPos.func_177952_p() + 0.5, this.speedModifier);
    }

    protected boolean findNearestBlock() {
        int j = this.verticalSearchRange;
        BlockPos blockpos = this.entity.func_233580_cy_();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k = this.verticalSearchStart; k >= -j; --k) {
            for (int l = 0; l < this.searchRange; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        blockpos$mutable.func_239621_a_((Vector3i)blockpos, i1, k, j1);
                        if (this.entity.func_213389_a((BlockPos)blockpos$mutable) && this.isValidTarget((IWorldReader)this.entity.field_70170_p, (BlockPos)blockpos$mutable)) {
                            this.blockPos = blockpos$mutable;
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
        }
        return false;
    }

    protected abstract boolean isValidTarget(@Nonnull IWorldReader var1, @Nonnull BlockPos var2);

    public static enum Orientation {
        ABOVE,
        IN,
        BESIDE;

    }
}

