/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.ChestLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import uk.joshiejack.husbandry.block.HusbandryBlocks;
import uk.joshiejack.husbandry.item.HusbandryItems;

public class HusbandryLootTables
extends LootTableProvider {
    public HusbandryLootTables(DataGenerator generator) {
        super(generator);
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationTracker validationtracker) {
        map.forEach((name, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)name, (LootTable)table));
    }

    @Nonnull
    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootParameterSets.field_216267_h), (Object)Pair.of(Chests::new, (Object)LootParameterSets.field_216262_c), (Object)Pair.of(Entities::new, (Object)LootParameterSets.field_216263_d));
    }

    public static class Chests
    extends ChestLootTables {
        public void accept(@Nonnull BiConsumer<ResourceLocation, LootTable.Builder> builder) {
        }
    }

    public static class Blocks
    extends BlockLootTables {
        @Nonnull
        protected Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> "husbandry".equals(Objects.requireNonNull(block.getRegistryName()).func_110624_b())).collect(Collectors.toList());
        }

        protected void addTables() {
            this.func_218492_c((Block)HusbandryBlocks.FEEDING_TRAY.get());
            this.func_218492_c((Block)HusbandryBlocks.BOWL.get());
            this.func_218492_c((Block)HusbandryBlocks.NEST.get());
            this.func_218492_c((Block)HusbandryBlocks.INCUBATOR.get());
            this.func_218492_c((Block)HusbandryBlocks.TROUGH.get());
            this.func_218522_a((Block)HusbandryBlocks.TRUFFLE_BLOCK.get(), block -> Blocks.func_218519_a((Block)block, (LootEntry.Builder)((LootEntry.Builder)Blocks.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)HusbandryItems.TRUFFLE.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t))))));
        }
    }

    public static class Entities
    extends EntityLootTables {
        @Nonnull
        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITIES.getValues().stream().filter(block -> "husbandry".equals(Objects.requireNonNull(block.getRegistryName()).func_110624_b())).collect(Collectors.toList());
        }

        protected CompoundNBT color(DyeColor color) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74774_a("Color", (byte)color.func_196059_a());
            return tag;
        }

        protected void addTables() {
            this.addProducts("mushroom_stew", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151009_A))));
            this.addProducts("milk", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151117_aB))));
            this.addProducts("truffle", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)HusbandryBlocks.TRUFFLE_BLOCK.get())))));
            this.addProducts("chicken_egg", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151110_aK))));
            this.addProducts("rabbit_foot", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_179556_br).func_212840_b_(RandomChance.func_216004_a((float)0.1f)))));
            this.addProducts("wool", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)5.0f, (float)11.0f)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221603_aE).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.WHITE)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221604_aF).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.ORANGE)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221605_aG).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.MAGENTA)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221606_aH).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.LIGHT_BLUE)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221607_aI).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.YELLOW)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221608_aJ).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.LIME)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221609_aK).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.PINK)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221610_aL).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.GRAY)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221611_aM).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.LIGHT_GRAY)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221612_aN).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.CYAN)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221613_aO).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.PURPLE)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221614_aP).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.BLUE)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221615_aQ).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.BROWN)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221616_aR).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.GREEN)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221617_aS).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.RED)))))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221618_aT).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_209365_a(new NBTPredicate(this.color(DyeColor.BLACK))))))));
        }

        protected void addProducts(String type, LootTable.Builder builder) {
            ResourceLocation lootTable = new ResourceLocation("husbandry", "entities/products/" + type);
            super.func_218585_a(lootTable, builder);
        }
    }
}

