/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.client.renderer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

@OnlyIn(value=Dist.CLIENT)
public class EggSupplierBakedModel
extends BakedModelWrapper<IBakedModel> {
    private final Map<Item, Map<Direction, List<BakedQuad>>> QUADS = new HashMap<Item, Map<Direction, List<BakedQuad>>>();
    private final Map<Item, ResourceLocation> overrides;
    private final ModelProperty<ItemStack> property;

    public EggSupplierBakedModel(IBakedModel originalModel, Map<Item, ResourceLocation> overrides, ModelProperty<ItemStack> property) {
        super(originalModel);
        this.overrides = overrides;
        this.property = property;
    }

    private Item defaultItem(Item item) {
        return this.overrides.containsKey(item) ? item : Items.field_151110_aK;
    }

    private Map<Direction, List<BakedQuad>> getQuads(Item item) {
        if (!this.QUADS.containsKey(item)) {
            this.QUADS.put(item, new HashMap());
        }
        return this.QUADS.get(item);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random random, @Nonnull IModelData data) {
        ItemStack stack;
        if (state != null && data.hasProperty(this.property) && (stack = (ItemStack)data.getData(this.property)) != null && !stack.func_190926_b()) {
            Map<Direction, List<BakedQuad>> map = this.getQuads(this.defaultItem(stack.func_77973_b()));
            if (map.containsKey(side)) {
                return map.get(side);
            }
            ArrayList quads = Lists.newArrayList((Iterable)super.getQuads(state, side, random, data));
            Minecraft mc = Minecraft.func_71410_x();
            if (!this.overrides.containsKey(stack.func_77973_b())) {
                IBakedModel item = mc.func_175599_af().func_184393_a(stack, (World)mc.field_71441_e, (LivingEntity)mc.field_71439_g);
                quads.addAll(item.func_200117_a(null, side, random));
            } else {
                quads.addAll(mc.func_209506_al().getModel(this.overrides.get(stack.func_77973_b())).func_200117_a(null, side, random));
            }
            map.put(side, quads);
            return quads;
        }
        return super.getQuads(state, side, random, data);
    }
}

