/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import uk.joshiejack.husbandry.Husbandry;
import uk.joshiejack.husbandry.block.HusbandryBlocks;
import uk.joshiejack.husbandry.client.gui.PageStats;
import uk.joshiejack.husbandry.client.renderer.EggSupplierBakedModel;
import uk.joshiejack.husbandry.tileentity.IncubatorTileEntity;
import uk.joshiejack.husbandry.tileentity.NestTileEntity;
import uk.joshiejack.penguinlib.client.gui.book.Book;
import uk.joshiejack.penguinlib.client.gui.book.page.AbstractPage;
import uk.joshiejack.penguinlib.client.gui.book.tab.NotesTab;
import uk.joshiejack.penguinlib.client.gui.book.tab.Tab;
import uk.joshiejack.penguinlib.inventory.AbstractBookContainer;
import uk.joshiejack.penguinlib.util.icon.Icon;
import uk.joshiejack.penguinlib.util.icon.TextureIcon;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="husbandry", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class HusbandryClient {
    public static final ResourceLocation FODDER = new ResourceLocation("husbandry", "block/fodder");
    public static final ResourceLocation SLOP = new ResourceLocation("husbandry", "block/slop");
    public static final ResourceLocation DEFAULT_NEST_EGG = new ResourceLocation("husbandry", "block/nest_egg");
    public static final ResourceLocation DEFAULT_INCUBATOR_EGG = new ResourceLocation("husbandry", "block/incubator_egg");

    @SubscribeEvent
    public static void onMapping(TextureStitchEvent.Pre event) {
        event.addSprite(FODDER);
        event.addSprite(SLOP);
    }

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Husbandry.HusbandryContainers.BOOK.get()), (container, inv, text) -> Book.getInstance((String)"husbandry", (AbstractBookContainer)container, (PlayerInventory)inv, (ITextComponent)text, bs -> {
            TranslationTextComponent stats = new TranslationTextComponent("gui.husbandry.stats");
            TranslationTextComponent notes = new TranslationTextComponent("gui.husbandry.notes");
            bs.withTab(new Tab((ITextComponent)stats, PageStats.ICON)).withPage((AbstractPage)new PageStats((ITextComponent)stats));
            bs.withTab((Tab)new NotesTab((ITextComponent)notes, (Icon)new TextureIcon(Icon.DEFAULT_LOCATION, 0, 0)).withCategory(new ResourceLocation("husbandry", "care_category")));
        }));
        RenderType cutout = RenderType.func_228643_e_();
        RenderTypeLookup.setRenderLayer((Block)((Block)HusbandryBlocks.FEEDING_TRAY.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)HusbandryBlocks.NEST.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)HusbandryBlocks.BOWL.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)HusbandryBlocks.INCUBATOR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)HusbandryBlocks.TRUFFLE_BLOCK.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)HusbandryBlocks.TROUGH.get()), (RenderType)cutout);
    }

    @SubscribeEvent
    public static void loadModels(ModelRegistryEvent event) {
        ModelLoader.addSpecialModel((ResourceLocation)DEFAULT_NEST_EGG);
        ModelLoader.addSpecialModel((ResourceLocation)DEFAULT_INCUBATOR_EGG);
    }

    private static void replaceWithEggSupplier(String model, ModelBakeEvent event, Map<Item, ResourceLocation> overrides, ModelProperty<ItemStack> property) {
        ModelResourceLocation key = new ModelResourceLocation(model);
        IBakedModel nest = event.getModelManager().getModel((ResourceLocation)key);
        if (!(event.getModelRegistry().get(key) instanceof EggSupplierBakedModel)) {
            event.getModelRegistry().put(key, new EggSupplierBakedModel(nest, overrides, property));
        }
    }

    @SubscribeEvent
    public static void onBaking(ModelBakeEvent event) {
        HashMap<Item, ResourceLocation> nest = new HashMap<Item, ResourceLocation>();
        nest.put(Items.field_151110_aK, DEFAULT_NEST_EGG);
        HashMap<Item, ResourceLocation> incubator = new HashMap<Item, ResourceLocation>();
        incubator.put(Items.field_151110_aK, DEFAULT_INCUBATOR_EGG);
        HusbandryClient.replaceWithEggSupplier("husbandry:nest#", event, nest, NestTileEntity.ITEM_STACK);
        HusbandryClient.replaceWithEggSupplier("husbandry:incubator#facing=north", event, incubator, IncubatorTileEntity.ITEM_STACK);
        HusbandryClient.replaceWithEggSupplier("husbandry:incubator#facing=east", event, incubator, IncubatorTileEntity.ITEM_STACK);
        HusbandryClient.replaceWithEggSupplier("husbandry:incubator#facing=west", event, incubator, IncubatorTileEntity.ITEM_STACK);
        HusbandryClient.replaceWithEggSupplier("husbandry:incubator#facing=south", event, incubator, IncubatorTileEntity.ITEM_STACK);
    }
}

