/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry;

import com.google.common.base.CaseFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.joshiejack.husbandry.api.HusbandryAPI;
import uk.joshiejack.husbandry.api.IMobStats;
import uk.joshiejack.husbandry.api.trait.IMobTrait;
import uk.joshiejack.husbandry.block.HusbandryBlocks;
import uk.joshiejack.husbandry.crafting.HusbandryRegistries;
import uk.joshiejack.husbandry.data.HusbandryBlockStates;
import uk.joshiejack.husbandry.data.HusbandryBlockTags;
import uk.joshiejack.husbandry.data.HusbandryDatabase;
import uk.joshiejack.husbandry.data.HusbandryItemModels;
import uk.joshiejack.husbandry.data.HusbandryItemTags;
import uk.joshiejack.husbandry.data.HusbandryLanguage;
import uk.joshiejack.husbandry.data.HusbandryLootTables;
import uk.joshiejack.husbandry.data.HusbandryRecipes;
import uk.joshiejack.husbandry.entity.MobDataLoader;
import uk.joshiejack.husbandry.entity.stats.MobStats;
import uk.joshiejack.husbandry.entity.traits.food.EatsBirdFeedTrait;
import uk.joshiejack.husbandry.entity.traits.food.EatsCatFoodTrait;
import uk.joshiejack.husbandry.entity.traits.food.EatsDogFoodTrait;
import uk.joshiejack.husbandry.entity.traits.food.EatsGrassTrait;
import uk.joshiejack.husbandry.entity.traits.food.EatsRabbitFoodTrait;
import uk.joshiejack.husbandry.entity.traits.food.EatsSlopTrait;
import uk.joshiejack.husbandry.entity.traits.food.RequiresFoodTrait;
import uk.joshiejack.husbandry.entity.traits.happiness.CarriableTrait;
import uk.joshiejack.husbandry.entity.traits.happiness.CleanableTrait;
import uk.joshiejack.husbandry.entity.traits.happiness.PettableTrait;
import uk.joshiejack.husbandry.entity.traits.happiness.TreatableTrait;
import uk.joshiejack.husbandry.entity.traits.lifestyle.AquaphobicTrait;
import uk.joshiejack.husbandry.entity.traits.lifestyle.AstraphobicTrait;
import uk.joshiejack.husbandry.entity.traits.lifestyle.DiurnalTrait;
import uk.joshiejack.husbandry.entity.traits.lifestyle.LameableTrait;
import uk.joshiejack.husbandry.entity.traits.lifestyle.MammalTrait;
import uk.joshiejack.husbandry.entity.traits.lifestyle.MortalTrait;
import uk.joshiejack.husbandry.entity.traits.lifestyle.NocturnalTrait;
import uk.joshiejack.husbandry.entity.traits.lifestyle.PetTrait;
import uk.joshiejack.husbandry.entity.traits.product.BowlableTrait;
import uk.joshiejack.husbandry.entity.traits.product.Bucketable;
import uk.joshiejack.husbandry.entity.traits.product.DropsProductTrait;
import uk.joshiejack.husbandry.entity.traits.product.FasterProductResetTrait;
import uk.joshiejack.husbandry.entity.traits.product.FindsProductTrait;
import uk.joshiejack.husbandry.entity.traits.product.LaysEggTrait;
import uk.joshiejack.husbandry.entity.traits.product.MoreProductChanceTrait;
import uk.joshiejack.husbandry.entity.traits.product.MoreProductTrait;
import uk.joshiejack.husbandry.entity.traits.product.ShearableTrait;
import uk.joshiejack.husbandry.inventory.MobTrackerContainer;
import uk.joshiejack.husbandry.item.HusbandryItems;
import uk.joshiejack.husbandry.note.LifespanNoteType;
import uk.joshiejack.husbandry.note.PregnancyNoteType;
import uk.joshiejack.husbandry.tileentity.HusbandryTileEntities;
import uk.joshiejack.penguinlib.inventory.AbstractBookContainer;
import uk.joshiejack.penguinlib.note.type.NoteType;
import uk.joshiejack.penguinlib.util.helpers.ReflectionHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="husbandry")
public class Husbandry {
    public static final String MODID = "husbandry";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ItemGroup TAB = new ItemGroup("husbandry"){

        @Nonnull
        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)HusbandryItems.BRUSH.get());
        }
    };

    public Husbandry() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        HusbandryContainers.CONTAINERS.register(eventBus);
        HusbandryBlocks.BLOCKS.register(eventBus);
        HusbandryItems.ITEMS.register(eventBus);
        HusbandryRegistries.SERIALIZERS.register(eventBus);
        HusbandrySounds.SOUNDS.register(eventBus);
        HusbandryTileEntities.TILE_ENTITIES.register(eventBus);
        HusbandryAPI.instance = new HusbandryAPIImpl();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, HusbandryConfig.create());
    }

    private void registerTrait(Class<? extends IMobTrait> data) {
        HusbandryAPI.instance.registerMobTrait(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, data.getSimpleName().replace("Trait", "")), data);
    }

    private void registerNoteType(Class<? extends NoteType> type) {
        ReflectionHelper.newInstance(type);
    }

    private void setup(FMLCommonSetupEvent event) {
        this.registerNoteType(LifespanNoteType.class);
        this.registerNoteType(PregnancyNoteType.class);
        this.registerTrait(EatsBirdFeedTrait.class);
        this.registerTrait(EatsCatFoodTrait.class);
        this.registerTrait(EatsDogFoodTrait.class);
        this.registerTrait(EatsGrassTrait.class);
        this.registerTrait(EatsRabbitFoodTrait.class);
        this.registerTrait(EatsSlopTrait.class);
        this.registerTrait(CarriableTrait.class);
        this.registerTrait(CleanableTrait.class);
        this.registerTrait(PettableTrait.class);
        this.registerTrait(TreatableTrait.class);
        this.registerTrait(AstraphobicTrait.class);
        this.registerTrait(AquaphobicTrait.class);
        this.registerTrait(DiurnalTrait.class);
        this.registerTrait(MammalTrait.class);
        this.registerTrait(MortalTrait.class);
        this.registerTrait(PetTrait.class);
        this.registerTrait(BowlableTrait.class);
        this.registerTrait(DropsProductTrait.class);
        this.registerTrait(FasterProductResetTrait.class);
        this.registerTrait(FindsProductTrait.class);
        this.registerTrait(LaysEggTrait.class);
        this.registerTrait(Bucketable.class);
        this.registerTrait(MoreProductChanceTrait.class);
        this.registerTrait(MoreProductTrait.class);
        this.registerTrait(ShearableTrait.class);
        this.registerTrait(NocturnalTrait.class);
        this.registerTrait(RequiresFoodTrait.class);
        this.registerTrait(LameableTrait.class);
    }

    @SubscribeEvent
    public static void onDataGathering(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new HusbandryLootTables(generator));
            HusbandryBlockTags blockTags = new HusbandryBlockTags(generator, event.getExistingFileHelper());
            generator.func_200390_a((IDataProvider)blockTags);
            generator.func_200390_a((IDataProvider)new HusbandryItemTags(generator, blockTags, event.getExistingFileHelper()));
            generator.func_200390_a((IDataProvider)new HusbandryRecipes(generator));
            generator.func_200390_a((IDataProvider)new HusbandryDatabase(generator));
            generator.func_200390_a((IDataProvider)new HusbandryBlockStates(generator, event.getExistingFileHelper()));
        }
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new HusbandryLanguage(generator));
            generator.func_200390_a((IDataProvider)new HusbandryItemModels(generator, event.getExistingFileHelper()));
        }
    }

    public static class HusbandryConfig {
        public static ForgeConfigSpec.IntValue maxHappiness;
        public static ForgeConfigSpec.IntValue hungerHappinessLoss;
        public static ForgeConfigSpec.IntValue hurtHappinessLossModifier;
        public static ForgeConfigSpec.IntValue dirtyHappinessLoss;
        public static ForgeConfigSpec.IntValue wrongTreatLoss;
        public static ForgeConfigSpec.IntValue lovedGain;
        public static ForgeConfigSpec.IntValue fedGain;
        public static ForgeConfigSpec.IntValue cleanedGain;
        public static ForgeConfigSpec.IntValue genericTreatGain;
        public static ForgeConfigSpec.IntValue typeTreatGain;
        public static ForgeConfigSpec.IntValue outsideGain;
        public static ForgeConfigSpec.IntValue birthGain;
        public static ForgeConfigSpec.IntValue daysPerYear;

        HusbandryConfig(ForgeConfigSpec.Builder builder) {
            builder.push("General Settings");
            daysPerYear = builder.defineInRange("Animal lifespan days per year", 112, 7, 700000);
            builder.pop();
            builder.push("Happiness Settings");
            maxHappiness = builder.defineInRange("Maximum happiness", 30000, 100, 100000000);
            hungerHappinessLoss = builder.defineInRange("Happiness lost from hunger", 1, 0, 100000);
            hurtHappinessLossModifier = builder.defineInRange("Happiness loss from hurt multiplier", 5, 0, 100);
            dirtyHappinessLoss = builder.defineInRange("Happiness lost from being unclean", 1, 0, 100000);
            wrongTreatLoss = builder.defineInRange("Happiness lost from incorrect treat type", 500, 0, 100000);
            lovedGain = builder.defineInRange("Happiness gained from petting/carrying", 100, 0, 100000);
            fedGain = builder.defineInRange("Happiness gained from hand feeding", 100, 0, 100000);
            cleanedGain = builder.defineInRange("Happiness gained from cleaning", 30, 0, 100000);
            genericTreatGain = builder.defineInRange("Happiness gained from generic treats", 100, 0, 100000);
            typeTreatGain = builder.defineInRange("Happiness gained from type treats", 250, 0, 100000);
            outsideGain = builder.defineInRange("Happiness gained from being outside in the sun", 2, 0, 100000);
            birthGain = builder.defineInRange("Happiness gained from giving birth", 100, 0, 100000);
            builder.pop();
        }

        public static ForgeConfigSpec create() {
            return (ForgeConfigSpec)new ForgeConfigSpec.Builder().configure(HusbandryConfig::new).getValue();
        }
    }

    public static class HusbandryAPIImpl
    implements HusbandryAPI.IHusbandryAPI {
        @Override
        public void registerMobTrait(String name, Class<? extends IMobTrait> trait) {
            MobDataLoader.TRAITS.put(name, (IMobTrait)ReflectionHelper.newInstance(trait));
        }

        @Override
        @Nullable
        public <E extends MobEntity> IMobStats<E> getStatsForEntity(E entity) {
            return MobStats.getStats(entity);
        }
    }

    public static class HusbandrySounds {
        public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"husbandry");
        public static final RegistryObject<SoundEvent> BRUSH = HusbandrySounds.createSoundEvent("brush");

        private static RegistryObject<SoundEvent> createSoundEvent(@Nonnull String name) {
            return SOUNDS.register(name, () -> new SoundEvent(new ResourceLocation(Husbandry.MODID, name)));
        }
    }

    public static class HusbandryContainers {
        public static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"husbandry");
        public static final RegistryObject<ContainerType<AbstractBookContainer>> BOOK = CONTAINERS.register("mob_tracker", () -> IForgeContainerType.create((id, inv, data) -> new MobTrackerContainer(id)));
    }
}

