from PIL import Image
import math

# 图像尺寸（推荐256x256）
size = 2048
# 创建透明背景图像
img = Image.new('RGBA', (size, size), (0, 0, 0, 0))
pixels = img.load()

# 中心点坐标
center_x, center_y = size // 2, size // 2
# 最大半径（到图像角落的距离）
max_radius = math.sqrt(center_x**2 + center_y**2)

# 更亮的金色 RGB(255, 230, 100)
gold_r, gold_g, gold_b = 255, 230, 100

# 中心透明区域比例（0.0-1.0）
center_transparent_ratio = 0.50  # 85%的半径内透明
edge_start_ratio = 0.95  # 95%的半径处开始完全不透明

for y in range(size):
    for x in range(size):
        # 计算当前像素到中心的距离
        dx = x - center_x
        dy = y - center_y
        distance = math.sqrt(dx*dx + dy*dy)
        normalized_distance = distance / max_radius
        
        # 在中心区域完全透明
        if normalized_distance < center_transparent_ratio:
            alpha = 0
        # 在边缘区域完全不透明
        elif normalized_distance > edge_start_ratio:
            alpha = 180
        # 在过渡区域平滑渐变
        else:
            # 计算过渡比例
            transition_ratio = (normalized_distance - center_transparent_ratio) / (edge_start_ratio - center_transparent_ratio)
            alpha = int(180 * transition_ratio)
        
        # 设置像素颜色（金色 + 计算出的透明度）
        pixels[x, y] = (gold_r, gold_g, gold_b, alpha)

# 保存图像
img.save("golden_vignette.png")
print("改进的金色晕影纹理已生成: golden_vignette.png")
