/*
 * Decompiled with CFR 0.152.
 */
package me.ctidy.mcmod.ftb.ultimine.indicator.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbultimine.CooldownTracker;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.shape.ShapeRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import me.ctidy.mcmod.ftb.ultimine.indicator.Constants;
import me.ctidy.mcmod.ftb.ultimine.indicator.config.FTBUltimineIndicatorClientConfig;
import me.ctidy.mcmod.ftb.ultimine.indicator.mixin.FTBUltimineClientAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;

public class ClientHandler {
    public static final String SHAPE_ICON_ID = "shape_icon";
    public static final String SHAPE_ICON_PATH = "ftbultimine_indicator/shape_icon/";
    public static final String SHAPE_ICON_MISSING_ID = "missing";
    private static Map<String, TextureAtlasSprite> SHAPE_ICONS = Collections.emptyMap();
    private static final ResourceLocation MISSING_ICON_ID = Constants.id("ftbultimine_indicator/shape_icon/missing");
    private static TextureAtlasSprite missing;

    public static CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier barrier, ResourceManager resourceManager, ProfilerFiller preparationProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.completedFuture(Unit.INSTANCE).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).m_6769_(arg_0))).thenRunAsync(ClientHandler::reload, gameExecutor);
    }

    public static void reload() {
        TextureAtlas atlas = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        missing = atlas.m_118316_(MISSING_ICON_ID);
        builder.put((Object)SHAPE_ICON_MISSING_ID, (Object)missing);
        int count = ShapeRegistry.shapeCount();
        for (int i = 0; i < count; ++i) {
            String name = ShapeRegistry.getShape((int)i).getName();
            TextureAtlasSprite sprite = atlas.m_118316_(Constants.id(name).m_246208_(SHAPE_ICON_PATH));
            if (MissingTextureAtlasSprite.m_118071_().equals((Object)sprite.m_245424_().m_246162_())) {
                sprite = missing;
            }
            builder.put((Object)name, (Object)sprite);
        }
        SHAPE_ICONS = builder.build();
    }

    public static void renderHud(GuiGraphics guiGraphics, Window window, float partialTicks) {
        FTBUltimineClientAccessor client;
        FTBUltimineCommon fTBUltimineCommon;
        if (!(((Boolean)FTBUltimineIndicatorClientConfig.enableIndicator.get()).booleanValue() && (fTBUltimineCommon = FTBUltimine.instance.proxy) instanceof FTBUltimineClientAccessor && (client = (FTBUltimineClientAccessor)fTBUltimineCommon).isPressed())) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        String shapeName = ShapeRegistry.getShape((int)client.getShapeIdx()).getName();
        int centerX = window.m_85445_() / 2 + 30;
        int centerY = window.m_85446_() / 2 - 3;
        if (((Boolean)FTBUltimineIndicatorClientConfig.showIndicatorStatus.get()).booleanValue()) {
            MutableComponent textStatus = CooldownTracker.isOnCooldown((Player)mc.f_91074_) ? Component.m_237115_((String)"ftbultimine.info.cooldown").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)12566412))) : (client.canUltimine() && client.getActualBlocks() > 0 ? Component.m_237110_((String)"ftbultimine.info.blocks", (Object[])new Object[]{client.getActualBlocks()}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)10731148))) : Component.m_237115_((String)"ftbultimine.info.not_active").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)12542314))));
            guiGraphics.m_280614_(mc.f_91062_, (Component)textStatus, centerX - mc.f_91062_.m_92852_((FormattedText)textStatus) / 2, centerY + 12, 15527924, true);
        }
        if (((Boolean)FTBUltimineIndicatorClientConfig.showShapeName.get()).booleanValue() && client.isSneak()) {
            MutableComponent textShapeName = Component.m_237115_((String)("ftbultimine.shape." + shapeName));
            Font font = mc.f_91062_;
            Objects.requireNonNull(mc.f_91062_);
            guiGraphics.m_280614_(font, (Component)textShapeName, centerX + 15, centerY + 2 - 9 / 2, 15527924, true);
        }
        TextureAtlasSprite sprite = SHAPE_ICONS.getOrDefault(shapeName, missing);
        int width = sprite.m_245424_().m_246492_();
        int height = sprite.m_245424_().m_245330_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        guiGraphics.m_280159_(centerX - width / 2, centerY - height / 2, 0, width, height, sprite);
    }
}

