/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.util.TaskScheduler;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class BurnItemScheduler {
    private final Mob mob;
    private final CompoundTag data;
    private static final List<String> burnMessages = Arrays.asList("I burned a %s", "I destroyed a %s", "Trash item removed, %s", "No room for this garbage, %s", "Away with this worthless %s", "This %s? Pathetic.", "I have no use for this %s", "Begone, filthy %s", "What even is this %s?", "%s? Into the flames you go.", "I spit on this %s", "Disgusting %s eliminated", "Only fools carry %s", "Carrying this %s would insult me", "Just setting fire to a %s, nothing special", "Another useless %s gone", "Why would anyone keep a %s?", "%s\u2026 trash belongs in the fire", "I don't hoard junk like this %s", "Hah, this %s is beneath me", "My inventory deserves better than a %s", "This %s offends me.", "Did someone seriously drop a %s?", "Get that %s out of my sight.", "This %s belongs in a dumpster fire.", "I'd rather hold a rotten potato than this %s", "The flames deserve the %s more than I do.", "I wouldn't even trade a stick for this %s", "Burning a %s improves the world", "Even zombies wouldn't use this %s", "Let fire consume the pathetic %s", "My hand feels dirty from touching this %s", "Purging the %s like it never existed", "This %s? Yeah, no.", "Useless %s detected and removed", "Say goodbye to your precious %s", "Who dropped this excuse of a %s?", "I refuse to carry this %s any longer.", "Only peasants use a %s", "Cursed %s gone.", "Trash fire activated, %s", "Firing up the pit for a %s", "Look what I found\u2026 a disgusting %s", "I clean the world of %s like this", "Into the fire, you go, %s", "Burning this %s makes me stronger", "This %s is a disgrace to all gear", "Flames, take this %s from my sight", "An offering to the lava gods, %s", "You call this a %s? Please.", "Throwing away this %s like it's nothing", "A toddler's toy? No, it's just a %s", "This %s was a mistake to create", "Forged in mediocrity, %s", "This %s makes me lose brain cells", "The %s has been sentenced to fire");

    public BurnItemScheduler(Mob mob) {
        this.mob = mob;
        this.data = mob.getPersistentData();
    }

    private String getRandomBurnMessage(String itemName) {
        String template = burnMessages.get(new Random().nextInt(burnMessages.size()));
        return String.format(template, itemName);
    }

    private void resetItem() {
        if (this.data.m_128441_("av_idle_burn_backup_main_hand")) {
            CompoundTag fullTag = null;
            try {
                fullTag = TagParser.m_129359_((String)this.data.m_128461_("av_idle_burn_backup_main_hand"));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            String id = fullTag.m_128461_("id");
            String nbtPart = fullTag.m_128441_("tag") ? fullTag.m_128469_("tag").toString() : "";
            String cmd = "item replace entity @s weapon.mainhand with " + id;
            if (!nbtPart.isEmpty()) {
                cmd = cmd + nbtPart;
            }
            try {
                this.mob.m_20194_().m_129892_().m_82094_().execute(cmd, (Object)this.mob.m_20203_().m_81324_().m_81325_(4));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            this.data.m_128473_("av_idle_burn_backup_main_hand");
        }
    }

    public void run() {
        Level level = this.mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.mob.m_5448_() != null) {
            this.resetItem();
            return;
        }
        List items = this.mob.m_9236_().m_45976_(ItemEntity.class, this.mob.m_20191_().m_82400_(10.0));
        ItemEntity targetItem = items.stream().filter(item -> item.m_6084_() && !item.m_32055_().m_41619_()).findFirst().orElse(null);
        if (targetItem != null) {
            if (this.mob.m_21205_().m_41720_() != Items.f_42409_) {
                this.mob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42409_));
            }
            if (this.mob.m_21573_().m_6570_((Entity)targetItem, 0) == null) {
                this.resetItem();
                return;
            }
            this.mob.m_21573_().m_5624_((Entity)targetItem, 1.0);
            if (this.mob.m_5448_() != null) {
                this.resetItem();
                return;
            }
            if ((double)this.mob.m_20270_((Entity)targetItem) < 1.5) {
                this.mob.m_21563_().m_24950_(targetItem.m_20185_(), targetItem.m_20186_() + (double)targetItem.m_20206_() / 2.0, targetItem.m_20189_(), 30.0f, 30.0f);
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                targetItem.m_6074_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, targetItem.m_20185_(), targetItem.m_20186_(), targetItem.m_20189_(), 8, 0.2, 0.2, 0.2, 0.01);
                this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), SoundEvents.f_11942_, SoundSource.HOSTILE, 1.0f, 1.0f);
                String rawName = targetItem.m_32055_().m_41611_().getString();
                if (rawName.startsWith("[") && rawName.endsWith("]")) {
                    rawName = rawName.substring(1, rawName.length() - 1).toLowerCase();
                }
                if (ForgeRegistries.ENTITY_TYPES.getKey((Object)this.mob.m_6095_()).toString().equals("player_mobs:player_mob")) {
                    Random random = new Random();
                    if (random.nextFloat() < 0.05f) {
                        String message = "<" + this.mob.m_5446_().getString() + "> " + this.getRandomBurnMessage(rawName);
                        serverLevel.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)message), false);
                    }
                }
            }
            TaskScheduler.schedule(() -> new BurnItemScheduler(this.mob).run(), 20);
        } else {
            this.resetItem();
        }
    }
}

