/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.procedures;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.util.AnimationSheduler;
import com.pla.annoyingvillagers.util.BurnItemScheduler;
import com.pla.annoyingvillagers.util.DelayedTask;
import com.pla.annoyingvillagers.util.IdleAnimation;
import com.pla.annoyingvillagers.util.TaskScheduler;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class IdleHandlerProcedure {
    static Random RANDOM = new Random();

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        if (event.getEntity() != null && !mob.m_9236_().m_5776_() && (ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()).toString().equals("minecraft:zombie") || ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()).toString().equals("minecraft:husk") || ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()).toString().equals("minecraft:skeleton") || ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()).toString().equals("minecraft:stray") || ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()).toString().equals("minecraft:wither_skeleton") || ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()).toString().equals("annoyingvillagers:villager_scout") || ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()).toString().equals("annoyingvillagers:villager_scout_captain") || ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()).toString().equals("annoyingvillagers:jev"))) {
            IdleHandlerProcedure.performIdleAction(mob, IdleAction.BURN_ITEM);
        }
        if (event.getEntity() != null && ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()).toString().equals("player_mobs:player_mob")) {
            IdleHandlerProcedure.scheduleIdleActionDecision((Mob)event.getEntity());
        }
    }

    public static IdleAction getRandomIdleAction() {
        return RANDOM.nextFloat() < 0.8f ? IdleAction.BURN_ITEM : IdleAction.PLAY_ANIMATION;
    }

    private static void scheduleIdleActionDecision(Mob mob) {
        if (mob.m_20159_()) {
            return;
        }
        CompoundTag data = mob.getPersistentData();
        if (!data.m_128441_("av_idle_action")) {
            IdleAction action = IdleHandlerProcedure.getRandomIdleAction();
            data.m_128359_("av_idle_action", action.toString());
            IdleHandlerProcedure.performIdleAction(mob, action);
        } else {
            IdleHandlerProcedure.performIdleAction(mob, IdleAction.valueOf(data.m_128461_("av_idle_action")));
        }
    }

    private static void performIdleAction(final Mob mob, IdleAction action) {
        if (mob == null || mob.m_213877_() || mob.m_21224_()) {
            return;
        }
        CompoundTag data = mob.getPersistentData();
        if (mob.m_5448_() != null) {
            if (data.m_128441_("av_idle_action")) {
                data.m_128473_("av_idle_action");
            }
            if (data.m_128441_("av_idle_animation_playing")) {
                data.m_128473_("av_idle_animation_playing");
            }
            if (data.m_128441_("av_idle_animate_backup_main_hand")) {
                CompoundTag fullTag = null;
                try {
                    fullTag = TagParser.m_129359_((String)data.m_128461_("av_idle_animate_backup_main_hand"));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
                String id = fullTag.m_128461_("id");
                String nbtPart = fullTag.m_128441_("tag") ? fullTag.m_128469_("tag").toString() : "";
                String cmd = "item replace entity @s weapon.mainhand with " + id;
                if (!nbtPart.isEmpty()) {
                    cmd = cmd + nbtPart;
                }
                try {
                    mob.m_20194_().m_129892_().m_82094_().execute(cmd, (Object)mob.m_20203_().m_81324_().m_81325_(4));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
                data.m_128473_("av_idle_animate_backup_main_hand");
                if (data.m_128441_("av_idle_action")) {
                    data.m_128473_("av_idle_action");
                }
                if (data.m_128441_("idle_message_broadcasted")) {
                    data.m_128473_("idle_message_broadcasted");
                }
            }
            return;
        }
        switch (action) {
            case BURN_ITEM: {
                List nearbyItems = mob.m_9236_().m_45976_(ItemEntity.class, mob.m_20191_().m_82400_(2.0));
                if (nearbyItems.isEmpty() || data.m_128441_("av_idle_burn_backup_main_hand")) break;
                ItemStack held = mob.m_21205_();
                if (!held.m_41619_() && held.m_41720_() != Items.f_42409_) {
                    CompoundTag tag = new CompoundTag();
                    held.m_41739_(tag);
                    data.m_128359_("av_idle_burn_backup_main_hand", tag.toString());
                }
                TaskScheduler.schedule(() -> {
                    try {
                        new BurnItemScheduler(mob).run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }, 10);
                break;
            }
            case PLAY_ANIMATION: {
                mob.m_21573_().m_26573_();
                mob.m_20334_(0.0, 0.0, 0.0);
                mob.m_146922_(mob.m_6080_());
                if (data.m_128441_("av_idle_animate_backup_main_hand")) break;
                ItemStack held = mob.m_21205_();
                if (!held.m_41619_()) {
                    CompoundTag tag = new CompoundTag();
                    held.m_41739_(tag);
                    data.m_128359_("av_idle_animate_backup_main_hand", tag.toString());
                }
                final IdleAnimation idleAnimation = IdleAnimation.values()[RANDOM.nextInt(IdleAnimation.values().length)];
                new DelayedTask(40){

                    @Override
                    public void run() {
                        TaskScheduler.schedule(() -> {
                            if (mob == null || !mob.m_6084_() || mob.m_213877_() || mob.m_21224_()) {
                                return;
                            }
                            new AnimationSheduler(mob).run(idleAnimation, false, false);
                            TaskScheduler.schedule(() -> {
                                if (mob == null || !mob.m_6084_() || mob.m_213877_() || mob.m_21224_()) {
                                    return;
                                }
                                new AnimationSheduler(mob).run(idleAnimation, false, false);
                                TaskScheduler.schedule(() -> {
                                    if (mob == null || !mob.m_6084_() || mob.m_213877_() || mob.m_21224_()) {
                                        return;
                                    }
                                    new AnimationSheduler(mob).run(idleAnimation, false, false);
                                    TaskScheduler.schedule(() -> {
                                        if (mob == null || !mob.m_6084_() || mob.m_213877_() || mob.m_21224_()) {
                                            return;
                                        }
                                        new AnimationSheduler(mob).run(idleAnimation, false, false);
                                        TaskScheduler.schedule(() -> {
                                            if (mob == null || !mob.m_6084_() || mob.m_213877_() || mob.m_21224_()) {
                                                return;
                                            }
                                            new AnimationSheduler(mob).run(idleAnimation, false, false);
                                            TaskScheduler.schedule(() -> {
                                                if (mob == null || !mob.m_6084_() || mob.m_213877_() || mob.m_21224_()) {
                                                    return;
                                                }
                                                new AnimationSheduler(mob).run(idleAnimation, false, false);
                                                TaskScheduler.schedule(() -> {
                                                    if (mob == null || !mob.m_6084_() || mob.m_213877_() || mob.m_21224_()) {
                                                        return;
                                                    }
                                                    new AnimationSheduler(mob).run(idleAnimation, false, false);
                                                    TaskScheduler.schedule(() -> {
                                                        if (mob == null || !mob.m_6084_() || mob.m_213877_() || mob.m_21224_()) {
                                                            return;
                                                        }
                                                        new AnimationSheduler(mob).run(idleAnimation, false, true);
                                                    }, 5);
                                                }, 5);
                                            }, 5);
                                        }, 5);
                                    }, 5);
                                }, 5);
                            }, 5);
                        }, 5);
                    }
                };
            }
        }
    }

    public static enum IdleAction {
        BURN_ITEM,
        PLAY_ANIMATION;

    }
}

