/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.config.AnnoyingVillagersConfig;
import com.pla.annoyingvillagers.entity.AlexEntity;
import com.pla.annoyingvillagers.entity.JevDeadEntity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModItems;
import com.pla.annoyingvillagers.util.PathfinderMobInventory;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class JevEntity
extends PathfinderMobInventory {
    private UUID followTargetUUID;
    private AlexEntity followTarget;
    private boolean alexDeathMessageSent = false;

    public void setFollowTarget(AlexEntity followTarget) {
        this.followTarget = followTarget;
    }

    public void setFollowTargetUUID(UUID followTargetUUID) {
        this.followTargetUUID = followTargetUUID;
    }

    public JevEntity(PlayMessages.SpawnEntity spawnentity, Level level) {
        this((EntityType<JevEntity>)((EntityType)AnnoyingVillagersModEntities.JEV.get()), level);
    }

    public JevEntity(EntityType<JevEntity> entitytype, Level level) {
        super(entitytype, level);
        this.m_274367_(0.6f);
        this.f_21364_ = 10;
        this.m_21557_(false);
        this.m_6593_((Component)Component.m_237113_((String)"Jev"));
        this.m_21530_();
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)AnnoyingVillagersModItems.JEV_BOOK.get()));
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)AnnoyingVillagersModItems.JEV_PENCIL.get()));
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)AnnoyingVillagersModItems.JEV_GLASSES.get()));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, AlexEntity.class, 12.0f));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Monster.class, 5.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(2, new Goal(){

            public boolean m_8036_() {
                return JevEntity.this.followTarget != null && JevEntity.this.followTarget.m_6084_();
            }

            public void m_8037_() {
                if (JevEntity.this.followTarget != null && JevEntity.this.followTarget.m_6084_()) {
                    JevEntity.this.m_21573_().m_5624_((Entity)JevEntity.this.followTarget, 2.0);
                }
            }

            public boolean m_8045_() {
                return JevEntity.this.followTarget != null && JevEntity.this.followTarget.m_6084_() && (double)JevEntity.this.m_20270_((Entity)JevEntity.this.followTarget) > 10.0;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 5.0f));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData spawngroupdata1 = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (!this.m_9236_().m_5776_() && this.m_20194_() != null) {
            try {
                this.m_20194_().m_129892_().m_82094_().execute("team add alex", (Object)this.m_20203_().m_81324_().m_81325_(4));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        if (!this.m_9236_().m_5776_() && this.m_20194_() != null) {
            try {
                this.m_20194_().m_129892_().m_82094_().execute("team modify alex friendlyFire false", (Object)this.m_20203_().m_81324_().m_81325_(4));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        if (!this.m_9236_().m_5776_() && this.m_20194_() != null) {
            try {
                this.m_20194_().m_129892_().m_82094_().execute("team join alex @s", (Object)this.m_20203_().m_81324_().m_81325_(4));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return spawngroupdata1;
    }

    public void m_6667_(DamageSource pDamageSource) {
        super.m_6667_(pDamageSource);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel levelaccessor = (ServerLevel)level;
            if (((Boolean)AnnoyingVillagersConfig.PHYSIC_MOD_COMPAT.get()).booleanValue()) {
                ServerLevel serverlevel = levelaccessor;
                JevDeadEntity jevDeadEntity = new JevDeadEntity((EntityType<JevDeadEntity>)((EntityType)AnnoyingVillagersModEntities.JEV_DEAD.get()), (Level)serverlevel);
                jevDeadEntity.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), levelaccessor.m_213780_().m_188501_() * 360.0f, 0.0f);
                if (jevDeadEntity instanceof Mob) {
                    JevDeadEntity mob = jevDeadEntity;
                    mob.m_6518_((ServerLevelAccessor)serverlevel, levelaccessor.m_6436_(jevDeadEntity.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
                levelaccessor.m_7967_((Entity)jevDeadEntity);
                try {
                    jevDeadEntity.m_20194_().m_129892_().m_82094_().execute("kill @s", (Object)jevDeadEntity.m_20203_().m_81324_().m_81325_(4));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            double distanceSq;
            AlexEntity alex;
            if (this.followTarget == null && this.followTargetUUID != null) {
                Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.followTargetUUID);
                if (entity instanceof AlexEntity) {
                    this.followTarget = alex = (AlexEntity)entity;
                } else {
                    this.followTargetUUID = null;
                }
            }
            if (this.followTarget != null && !this.followTarget.m_6084_()) {
                if (!this.alexDeathMessageSent) {
                    this.alexDeathMessageSent = true;
                    alex = this.m_9236_();
                    if (alex instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)alex;
                        String[] ALEX_DEATH_LINES = new String[]{"Oh no... my Alex...", "Why... Alex, why did you leave me...", "I was supposed to protect you, Alex ...", "Alex, come back, please...", "Please, Alex, wake up...", "Alex...? No..."};
                        String message = ALEX_DEATH_LINES[this.m_9236_().m_213780_().m_188503_(ALEX_DEATH_LINES.length)];
                        serverLevel.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)("<Jev> " + message)), false);
                    }
                }
                this.followTarget = null;
                this.followTargetUUID = null;
            }
            if (this.followTarget != null && this.followTarget.m_6084_() && (distanceSq = this.m_20280_((Entity)this.followTarget)) > 600.0) {
                this.m_6021_(this.followTarget.m_20185_(), this.followTarget.m_20186_(), this.followTarget.m_20189_());
            }
        }
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.followTargetUUID != null) {
            tag.m_128362_("FollowTarget", this.followTargetUUID);
        }
        tag.m_128379_("AlexDeathMessageSent", this.alexDeathMessageSent);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("FollowTarget")) {
            this.followTargetUUID = tag.m_128342_("FollowTarget");
        }
        this.alexDeathMessageSent = tag.m_128471_("AlexDeathMessageSent");
    }

    public boolean m_6785_(double d0) {
        return false;
    }

    public double m_6049_() {
        return -0.35;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.ambient"));
    }

    public SoundEvent m_7975_(DamageSource damagesource) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float f) {
        if (damagesource.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268425_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268526_)) {
            return false;
        }
        return super.m_6469_(damagesource, f);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 50.0);
        builder = builder.m_22268_(Attributes.f_22284_, 1.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        builder = builder.m_22268_(Attributes.f_22278_, 5.0);
        return builder;
    }
}

