/*
 * Decompiled with CFR 0.152.
 */
package com.pla.annoyingvillagers.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pla.annoyingvillagers.config.AnnoyingVillagersConfig;
import com.pla.annoyingvillagers.entity.HerobrineDeadEntity;
import com.pla.annoyingvillagers.init.AnnoyingVillagersModEntities;
import com.pla.annoyingvillagers.procedures.HerobrineNaturalSpawnProcedure;
import com.pla.annoyingvillagers.procedures.HerobrineOnAwardKillScoreProcedure;
import com.pla.annoyingvillagers.procedures.HerobrineOnDeathProcedure;
import com.pla.annoyingvillagers.procedures.HerobrineOnEntityTickUpdateProcedure;
import com.pla.annoyingvillagers.procedures.HerobrineOnHurtProcedure;
import com.pla.annoyingvillagers.procedures.HerobrineOnInitialSpawnProcedure;
import com.pla.annoyingvillagers.procedures.HerobrineWhenEntityFallsProcedure;
import com.pla.annoyingvillagers.util.CommonGoals;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class HerobrineEntity
extends Monster {
    private boolean wasOnGroundLastTick = false;

    public HerobrineEntity(PlayMessages.SpawnEntity spawnentity, Level level) {
        this((EntityType<HerobrineEntity>)((EntityType)AnnoyingVillagersModEntities.HEROBRINE.get()), level);
    }

    public HerobrineEntity(EntityType<HerobrineEntity> entitytype, Level level) {
        super(entitytype, level);
        this.m_274367_(0.7f);
        this.f_21364_ = 300;
        this.m_21557_(false);
        this.m_6593_((Component)Component.m_237113_((String)"\u00a75Herobrine\u00a7r"));
        this.m_20340_(true);
        this.m_21530_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        CommonGoals.registerGoalForHostileNpc(this);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6785_(double d0) {
        return false;
    }

    public double m_6049_() {
        return -0.35;
    }

    protected void m_7472_(DamageSource damagesource, int i, boolean flag) {
        super.m_7472_(damagesource, i, flag);
        this.m_19983_(new ItemStack((ItemLike)Blocks.f_50080_));
    }

    public SoundEvent m_7975_(DamageSource damagesource) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "entity.generic.death"));
    }

    public void m_8038_(ServerLevel serverlevel, LightningBolt lightningbolt) {
        super.m_8038_(serverlevel, lightningbolt);
    }

    public boolean m_142535_(float f, float f1, DamageSource damagesource) {
        HerobrineWhenEntityFallsProcedure.execute();
        return super.m_142535_(f, f1, damagesource);
    }

    public boolean m_6469_(DamageSource damagesource, float f) {
        HerobrineOnHurtProcedure.execute((Entity)this);
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        return super.m_6469_(damagesource, f);
    }

    public void m_6667_(DamageSource damagesource) {
        super.m_6667_(damagesource);
        HerobrineOnDeathProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        Level levelAccessor = this.m_9236_();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel levelaccessor = (ServerLevel)levelAccessor;
            if (((Boolean)AnnoyingVillagersConfig.PHYSIC_MOD_COMPAT.get()).booleanValue()) {
                ServerLevel serverlevel = levelaccessor;
                HerobrineDeadEntity deadEntity = new HerobrineDeadEntity((EntityType<HerobrineDeadEntity>)((EntityType)AnnoyingVillagersModEntities.HEROBRINE_DEAD.get()), (Level)serverlevel);
                deadEntity.m_7678_(posX, posY, posZ, levelaccessor.m_213780_().m_188501_() * 360.0f, 0.0f);
                if (deadEntity instanceof Mob) {
                    HerobrineDeadEntity mob = deadEntity;
                    mob.m_6518_((ServerLevelAccessor)serverlevel, levelaccessor.m_6436_(deadEntity.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
                levelaccessor.m_7967_((Entity)deadEntity);
                try {
                    deadEntity.m_20194_().m_129892_().m_82094_().execute("kill @s", (Object)deadEntity.m_20203_().m_81324_().m_81325_(4));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverlevelaccessor, DifficultyInstance difficultyinstance, MobSpawnType mobspawntype, @Nullable SpawnGroupData spawngroupdata, @Nullable CompoundTag compoundtag) {
        SpawnGroupData spawngroupdata1 = super.m_6518_(serverlevelaccessor, difficultyinstance, mobspawntype, spawngroupdata, compoundtag);
        HerobrineOnInitialSpawnProcedure.execute((LevelAccessor)serverlevelaccessor, (Entity)this);
        return spawngroupdata1;
    }

    public void m_5993_(Entity entity, int i, DamageSource damagesource) {
        super.m_5993_(entity, i, damagesource);
        if (this.f_19796_.m_188501_() < ((Double)AnnoyingVillagersConfig.HEROBRINE_POSSESS_RATE.get()).floatValue()) {
            HerobrineOnAwardKillScoreProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), entity);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        HerobrineOnEntityTickUpdateProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)AnnoyingVillagersModEntities.HEROBRINE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entitytype, serverlevelaccessor, mobspawntype, blockpos, random) -> {
            int i = blockpos.m_123341_();
            int j = blockpos.m_123342_();
            int k = blockpos.m_123343_();
            return HerobrineNaturalSpawnProcedure.execute((LevelAccessor)serverlevelaccessor, i, j, k);
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 40.0);
        builder = builder.m_22268_(Attributes.f_22284_, 40.0);
        builder = builder.m_22268_(Attributes.f_22281_, 9.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22282_, 2.0);
        return builder;
    }
}

