/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.mods.gd656killicon.Config;
import org.mods.gd656killicon.Gd656killicon;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class KillIconRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation KILL_ICON = ResourceLocation.fromNamespaceAndPath((String)"gd656killicon", (String)"textures/gui/kill_icon.png");
    private static final List<KillIconInstance> activeIcons = new ArrayList<KillIconInstance>();
    private static String latestWeaponName = "";
    private static String latestTargetName = "";
    private static final int VERTICAL_OFFSET = -50;
    private static long lastKillTime = 0L;
    private static final int KILL_CHAIN_TIMEOUT = 3000;
    private static boolean isFadingOutAll = false;
    private static final int VISIBLE_THRESHOLD = 9;
    private static long FAST_FADE_INTERVAL = 75L;
    private static final long NORMAL_FADE_INTERVAL = 150L;
    private static final int HIGH_VOLUME_THRESHOLD = 20;
    private static long ULTRA_FAST_INTERVAL = 10L;

    private static void updateAllIconTargetPositions() {
        if (activeIcons.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int iconSize = Config.killIconSize;
        float centerX = (float)screenWidth / 2.0f;
        float iconSpacing = (float)iconSize * 1.25f;
        for (int i = 0; i < activeIcons.size(); ++i) {
            KillIconInstance icon = activeIcons.get(i);
            float position = (float)i - (float)(activeIcons.size() - 1) / 2.0f;
            float newTargetX = centerX + position * iconSpacing - (float)iconSize / 2.0f;
            if (!(Math.abs(icon.targetX - newTargetX) > 1.0f)) continue;
            icon.prevX = icon.currentX;
            icon.targetX = newTargetX;
            icon.positionAnimationStart = System.currentTimeMillis();
        }
    }

    public static void triggerKillIcon(String weaponName, String targetName) {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int iconSize = Config.killIconSize;
        KillIconInstance newIcon = new KillIconInstance(System.currentTimeMillis(), (float)screenWidth / 2.0f - (float)iconSize / 2.0f, mc.m_91268_().m_85446_() - 70 + -50);
        activeIcons.add(newIcon);
        if (activeIcons.size() > 9) {
            KillIconRenderer.startFadeOutSequence(System.currentTimeMillis());
        }
        if (activeIcons.size() >= 20) {
            KillIconRenderer.startFadeOutSequence(System.currentTimeMillis());
        } else if (activeIcons.size() > 9) {
            KillIconRenderer.startFadeOutSequence(System.currentTimeMillis());
        }
        KillIconRenderer.updateAllIconTargetPositions();
        lastKillTime = System.currentTimeMillis();
        isFadingOutAll = false;
        latestWeaponName = weaponName;
        latestTargetName = targetName;
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)Gd656killicon.KILL_SOUND.get()), (float)1.0f));
    }

    @SubscribeEvent
    public static void renderKillIcon(RenderGuiOverlayEvent.Post event) {
        boolean chainEnded;
        Minecraft mc = Minecraft.m_91087_();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        PoseStack poseStack = guiGraphics.m_280168_();
        long currentTime = System.currentTimeMillis();
        boolean bl = chainEnded = currentTime - lastKillTime > 3000L;
        if (chainEnded) {
            latestWeaponName = "";
            latestTargetName = "";
            if (!activeIcons.isEmpty() && !isFadingOutAll) {
                KillIconRenderer.startFadeOutSequence(currentTime);
            }
        }
        KillIconRenderer.renderIcons(guiGraphics, poseStack, currentTime);
        KillIconRenderer.renderSubtitles(guiGraphics);
    }

    private static void startFadeOutSequence(long currentTime) {
        isFadingOutAll = true;
        int totalIcons = activeIcons.size();
        int ultraFastCount = Math.max(0, totalIcons - 20);
        int fastCount = Math.max(0, totalIcons - ultraFastCount - 9);
        int normalCount = totalIcons - ultraFastCount - fastCount;
        for (int i = 0; i < totalIcons; ++i) {
            int indexInPhase;
            int reverseIndex = totalIcons - 1 - i;
            KillIconInstance icon = activeIcons.get(reverseIndex);
            if (i < ultraFastCount) {
                icon.fadeStartTime = currentTime + (long)i * ULTRA_FAST_INTERVAL;
                continue;
            }
            if (i < ultraFastCount + fastCount) {
                indexInPhase = i - ultraFastCount;
                icon.fadeStartTime = currentTime + (long)ultraFastCount * ULTRA_FAST_INTERVAL + (long)indexInPhase * FAST_FADE_INTERVAL;
                continue;
            }
            indexInPhase = i - ultraFastCount - fastCount;
            icon.fadeStartTime = currentTime + (long)ultraFastCount * ULTRA_FAST_INTERVAL + (long)fastCount * FAST_FADE_INTERVAL + (long)indexInPhase * 150L;
        }
    }

    private static void renderIcons(GuiGraphics guiGraphics, PoseStack poseStack, long currentTime) {
        if (activeIcons.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        Iterator<KillIconInstance> iterator = activeIcons.iterator();
        int iconSize = Config.killIconSize;
        while (iterator.hasNext()) {
            KillIconInstance icon = iterator.next();
            long elapsed = currentTime - icon.startTime;
            KillIconRenderer.updateIconAnimation(icon, elapsed, currentTime);
            if (icon.alpha <= 0.0f) {
                iterator.remove();
                KillIconRenderer.updateAllIconTargetPositions();
                continue;
            }
            KillIconRenderer.updatePosition(icon, currentTime);
            KillIconRenderer.renderSingleIcon(guiGraphics, poseStack, icon, iconSize);
        }
        RenderSystem.disableBlend();
    }

    private static void updateIconAnimation(KillIconInstance icon, long elapsed, long currentTime) {
        if (elapsed < 500L) {
            float progress = Mth.m_14036_((float)((float)elapsed / 500.0f), (float)0.0f, (float)1.0f);
            float easedProgress = 1.0f - (float)Math.pow(1.0f - progress, 3.0);
            icon.scale = Mth.m_14179_((float)easedProgress, (float)1.5f, (float)1.0f);
            icon.brightness = Mth.m_14179_((float)easedProgress, (float)4.0f, (float)1.0f);
        }
        if (icon.fadeStartTime != -1L && currentTime >= icon.fadeStartTime) {
            long fadeElapsed = currentTime - icon.fadeStartTime;
            float fadeProgress = Math.min((float)fadeElapsed / (float)(Config.killIconFadeTime * 50), 1.0f);
            icon.alpha = 1.0f - fadeProgress;
        }
    }

    private static void updatePosition(KillIconInstance icon, long currentTime) {
        if (Math.abs(icon.currentX - icon.targetX) > 0.1f) {
            long moveElapsed = currentTime - icon.positionAnimationStart;
            float progress = Math.min((float)moveElapsed / 300.0f, 1.0f);
            float easedProgress = 1.0f - (1.0f - progress) * (1.0f - progress);
            icon.currentX = Mth.m_14179_((float)easedProgress, (float)icon.prevX, (float)icon.targetX);
        }
    }

    private static void renderSingleIcon(GuiGraphics guiGraphics, PoseStack poseStack, KillIconInstance icon, int iconSize) {
        int scaledSize = (int)((float)iconSize * icon.scale);
        int offsetX = (iconSize - scaledSize) / 2;
        int offsetY = (iconSize - scaledSize) / 2;
        RenderSystem.setShaderColor((float)icon.brightness, (float)icon.brightness, (float)icon.brightness, (float)icon.alpha);
        poseStack.m_85836_();
        poseStack.m_252880_(icon.currentX + (float)offsetX, icon.baseY + (float)offsetY, 0.0f);
        poseStack.m_85841_(icon.scale, icon.scale, 1.0f);
        guiGraphics.m_280163_(KILL_ICON, 0, 0, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        poseStack.m_85849_();
    }

    private static void renderSubtitles(GuiGraphics guiGraphics) {
        if (latestWeaponName.isEmpty() || latestTargetName.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        MutableComponent fullText = Component.m_237113_((String)"\u4f60 \u4f7f\u7528 ").m_7220_((Component)Component.m_237113_((String)latestWeaponName).m_130948_(Style.f_131099_.m_178520_(Config.weaponColor).m_131136_(Boolean.valueOf(true)))).m_130946_(" \u51fb\u8d25\u4e86 ").m_7220_((Component)Component.m_237113_((String)latestTargetName).m_130948_(Style.f_131099_.m_178520_(Config.targetColor).m_131136_(Boolean.valueOf(true))));
        int screenWidth = mc.m_91268_().m_85445_();
        int textY = mc.m_91268_().m_85446_() - 30 + -50;
        int textX = screenWidth / 2 - font.m_92852_((FormattedText)fullText) / 2;
        RenderSystem.enableBlend();
        guiGraphics.m_280614_(font, (Component)fullText, textX, textY, -1, false);
        RenderSystem.disableBlend();
    }

    private static class KillIconInstance {
        public final long startTime;
        public float brightness;
        public float scale;
        public float alpha;
        public float prevX;
        public float currentX;
        public float targetX;
        public final float baseY;
        public long positionAnimationStart;
        public long fadeStartTime = -1L;

        public KillIconInstance(long startTime, float initialX, float baseY) {
            this.startTime = startTime;
            this.baseY = baseY;
            this.brightness = 4.0f;
            this.scale = 1.5f;
            this.alpha = 1.0f;
            this.prevX = initialX;
            this.currentX = initialX;
            this.targetX = initialX;
            this.positionAnimationStart = System.currentTimeMillis();
        }
    }
}

