/*
 * Decompiled with CFR 0.152.
 */
package org.mods.gd656killicon;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="gd656killicon", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.BooleanValue LOG_DIRT_BLOCK;
    public static ForgeConfigSpec.IntValue MAGIC_NUMBER;
    public static ForgeConfigSpec.ConfigValue<String> MAGIC_NUMBER_INTRODUCTION;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> ITEM_STRINGS;
    public static ForgeConfigSpec.IntValue KILL_ICON_DURATION;
    public static ForgeConfigSpec.IntValue KILL_ICON_FADE_TIME;
    public static ForgeConfigSpec.IntValue KILL_ICON_SIZE;
    public static ForgeConfigSpec.ConfigValue<String> WEAPON_COLOR;
    public static ForgeConfigSpec.ConfigValue<String> TARGET_COLOR;
    public static boolean logDirtBlock;
    public static int magicNumber;
    public static String magicNumberIntroduction;
    public static Set<Item> items;
    public static boolean debugMode;
    public static int killIconDuration;
    public static int killIconFadeTime;
    public static int killIconSize;
    public static int weaponColor;
    public static int targetColor;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }

    private static void loadConfig(ModConfigEvent event) {
        logDirtBlock = (Boolean)LOG_DIRT_BLOCK.get();
        magicNumber = (Integer)MAGIC_NUMBER.get();
        magicNumberIntroduction = (String)MAGIC_NUMBER_INTRODUCTION.get();
        items = ((List)ITEM_STRINGS.get()).stream().map(name -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)name))).collect(Collectors.toSet());
        killIconDuration = (Integer)KILL_ICON_DURATION.get();
        killIconFadeTime = (Integer)KILL_ICON_FADE_TIME.get();
        killIconSize = (Integer)KILL_ICON_SIZE.get();
        weaponColor = Config.parseColor((String)WEAPON_COLOR.get());
        targetColor = Config.parseColor((String)TARGET_COLOR.get());
    }

    private static int parseColor(String hex) {
        try {
            String colorStr = "FF" + hex.replace("#", "");
            return (int)Long.parseLong(colorStr, 16);
        }
        catch (Exception e) {
            LOGGER.error("Invalid color format: {}", (Object)hex);
            return -16744320;
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        Config.loadConfig((ModConfigEvent)event);
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        Config.loadConfig((ModConfigEvent)event);
    }

    static {
        debugMode = false;
        weaponColor = -16744320;
        targetColor = -16744320;
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General settings").push("general");
        LOG_DIRT_BLOCK = builder.comment("Whether to log dirt block info").define("logDirtBlock", true);
        MAGIC_NUMBER = builder.comment("A magic number").defineInRange("magicNumber", 42, 0, Integer.MAX_VALUE);
        MAGIC_NUMBER_INTRODUCTION = builder.define("magicNumberIntroduction", (Object)"The magic number is: ");
        ITEM_STRINGS = builder.comment("List of items").defineListAllowEmpty("items", List.of("minecraft:apple"), Config::validateItemName);
        builder.pop();
        builder.comment("Kill Icon settings").push("kill_icon");
        KILL_ICON_DURATION = builder.comment("Duration of kill icon display in ticks").defineInRange("duration", 40, 20, 200);
        KILL_ICON_FADE_TIME = builder.comment("Fade out time in ticks").defineInRange("fadeTime", 20, 10, 60);
        KILL_ICON_SIZE = builder.comment("Size of the kill icon in pixels").defineInRange("size", 24, 16, 64);
        builder.pop();
        builder.comment("Text color settings").push("text_colors");
        WEAPON_COLOR = builder.comment("Color for weapon text (hex format, e.g. 008080)").define("weaponColor", (Object)"008080");
        TARGET_COLOR = builder.comment("Color for target text (hex format, e.g. FF0000)").define("targetColor", (Object)"008080");
        builder.pop();
        SPEC = builder.build();
    }
}

