/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cartoonsoul.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.cartoonsoul.client.model.Modelground;
import net.mcreator.cartoonsoul.entity.GroundedEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;

public class GroundedRenderer
extends EntityRenderer<GroundedEntity> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("cartoon_soul:textures/entities/katana.png");
    private final Modelground model;
    private final Minecraft minecraft;

    public GroundedRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new Modelground(context.m_174023_(Modelground.LAYER_LOCATION));
        this.minecraft = Minecraft.m_91087_();
    }

    public void render(GroundedEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        RenderType renderType = this.getRenderType(entityIn);
        VertexConsumer vb = bufferIn.m_6299_(renderType);
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entityIn.f_19859_, (float)entityIn.m_146908_()) - 90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f + Mth.m_14179_((float)partialTicks, (float)entityIn.f_19860_, (float)entityIn.m_146909_())));
        if (entityIn.getStoredBlock() != null) {
            this.renderWithBlockTexture(entityIn, poseStack, vb, packedLightIn);
        } else {
            this.model.m_7695_(poseStack, vb, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    private void renderWithBlockTexture(GroundedEntity entity, PoseStack poseStack, VertexConsumer buffer, int packedLight) {
        Block block = entity.getStoredBlock();
        if (block == null) {
            return;
        }
        BakedModel model = this.minecraft.m_91289_().m_110910_(block.m_49966_());
        TextureAtlasSprite sprite = model.m_6160_();
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        this.model.m_7695_(poseStack, buffer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private RenderType getRenderType(GroundedEntity entity) {
        if (entity.getStoredBlock() != null) {
            return RenderType.m_110452_((ResourceLocation)TextureAtlas.f_118259_);
        }
        return RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entity));
    }

    public ResourceLocation getTextureLocation(GroundedEntity entity) {
        if (entity.getStoredBlock() != null) {
            return TextureAtlas.f_118259_;
        }
        return DEFAULT_TEXTURE;
    }
}

