/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cartoonsoul.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.cartoonsoul.client.model.Modelspike;
import net.mcreator.cartoonsoul.procedures.SpikedValueProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class SpikeParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private float angularVelocity;
    private float angularAcceleration;

    public static SpikeParticleProvider provider(SpriteSet spriteSet) {
        return new SpikeParticleProvider(spriteSet);
    }

    protected SpikeParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.m_107250_(0.2f, 0.2f);
        this.f_107663_ *= 5.0f;
        this.f_107225_ = Math.max(1, 15 + (this.f_107223_.m_188503_(20) - 10));
        this.f_107226_ = 1.0f;
        this.f_107219_ = true;
        this.f_107215_ = vx * 0.1;
        this.f_107216_ = vy * 0.1;
        this.f_107217_ = vz * 0.1;
        this.angularVelocity = 0.1f;
        this.angularAcceleration = 0.1f;
        this.m_108335_(spriteSet);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107434_;
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.angularVelocity;
        this.angularVelocity += this.angularAcceleration;
    }

    public static class SpikeParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public SpikeParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            final SpikeParticle particle = new SpikeParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            class SpikeRenderSequence {
                private ClientLevel world;
                public EntityModel model = new Modelspike(Minecraft.m_91087_().m_167973_().m_171103_(Modelspike.LAYER_LOCATION));
                private float scale = (float)SpikedValueProcedure.execute();
                private int rotX = (int)SpikedValueProcedure.execute();
                private int rotY = (int)SpikedValueProcedure.execute();
                private int rotZ = (int)SpikedValueProcedure.execute();

                SpikeRenderSequence() {
                }

                @SubscribeEvent
                public void render(RenderLevelStageEvent event) {
                    if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                        VertexConsumer consumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110458_((ResourceLocation)new ResourceLocation("cartoon_soul:textures/particle/spike.png")));
                        Vec3 camPos = event.getCamera().m_90583_();
                        double x = Mth.m_14139_((double)event.getPartialTick(), (double)particle.f_107209_, (double)particle.f_107212_) - camPos.m_7096_();
                        double y = Mth.m_14139_((double)event.getPartialTick(), (double)particle.f_107210_, (double)particle.f_107213_) - camPos.m_7098_();
                        double z = Mth.m_14139_((double)event.getPartialTick(), (double)particle.f_107211_, (double)particle.f_107214_) - camPos.m_7094_();
                        event.getPoseStack().m_85836_();
                        event.getPoseStack().m_85837_(x, y, z);
                        event.getPoseStack().m_252781_(Axis.f_252529_.m_252977_(180.0f));
                        event.getPoseStack().m_85841_(this.scale, this.scale, this.scale);
                        event.getPoseStack().m_252781_(Axis.f_252529_.m_252977_((float)this.rotX));
                        event.getPoseStack().m_252781_(Axis.f_252436_.m_252977_((float)this.rotY));
                        event.getPoseStack().m_252781_(Axis.f_252403_.m_252977_((float)this.rotZ));
                        this.model.m_7695_(event.getPoseStack(), consumer, particle.m_6355_(event.getPartialTick()), OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                        event.getPoseStack().m_85849_();
                    }
                }

                public void start(ClientLevel world) {
                    MinecraftForge.EVENT_BUS.register((Object)this);
                    this.world = world;
                }

                @SubscribeEvent
                public void tick(TickEvent.ClientTickEvent event) {
                    if (!particle.m_107276_()) {
                        this.end();
                    }
                }

                @SubscribeEvent
                public void dimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
                    this.end();
                }

                @SubscribeEvent
                public void loggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
                    this.end();
                }

                private void end() {
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                }
            }
            SpikeRenderSequence sequence = new SpikeRenderSequence();
            sequence.start(worldIn);
            return particle;
        }
    }
}

