/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cartoonsoul;

import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.mcreator.cartoonsoul.entity.CorruptedknightEntity;
import net.mcreator.cartoonsoul.entity.DwarfgolemEntity;
import net.mcreator.cartoonsoul.entity.JesterknightEntity;
import net.mcreator.cartoonsoul.entity.ObserverEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class BonePositionPacket {
    private final String entityType;
    private final String boneName;
    private final Vec3 position;

    public BonePositionPacket(String entityType, String boneName, Vec3 position) {
        this.entityType = entityType;
        this.boneName = boneName;
        this.position = position;
    }

    public static void encode(BonePositionPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130070_(packet.entityType);
        buffer.m_130070_(packet.boneName);
        buffer.writeDouble(packet.position.f_82479_);
        buffer.writeDouble(packet.position.f_82480_);
        buffer.writeDouble(packet.position.f_82481_);
    }

    public static BonePositionPacket decode(FriendlyByteBuf buffer) {
        String entityType = buffer.m_130277_();
        String boneName = buffer.m_130277_();
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        return new BonePositionPacket(entityType, boneName, new Vec3(x, y, z));
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getBoneName() {
        return this.boneName;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public static void handle(BonePositionPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerLevel level;
            Entity entity;
            ServerPlayer player = context.getSender();
            if (player != null && (entity = BonePositionPacket.findNearestEntity(level = player.m_284548_().m_6018_(), player.m_20182_(), packet.getEntityType())) != null) {
                if (entity instanceof JesterknightEntity) {
                    ((JesterknightEntity)entity).setBonePosition(packet.getBoneName(), packet.getPosition());
                } else if (entity instanceof DwarfgolemEntity) {
                    ((DwarfgolemEntity)entity).setBonePosition(packet.getBoneName(), packet.getPosition());
                } else if (entity instanceof ObserverEntity) {
                    ((ObserverEntity)entity).setBonePosition(packet.getBoneName(), packet.getPosition());
                } else if (entity instanceof CorruptedknightEntity) {
                    ((CorruptedknightEntity)entity).setBonePosition(packet.getBoneName(), packet.getPosition());
                }
            }
        });
        context.setPacketHandled(true);
    }

    private static Entity findNearestEntity(ServerLevel level, Vec3 position, String entityType) {
        Class<? extends Entity> entityClass = BonePositionPacket.getEntityClass(entityType);
        if (entityClass == null) {
            return null;
        }
        List entities = level.m_45976_(entityClass, new AABB(position.m_82492_(1000.0, 1000.0, 1000.0), position.m_82520_(1000.0, 1000.0, 1000.0)));
        return entities.stream().min(Comparator.comparingDouble(e -> e.m_20238_(position))).orElse(null);
    }

    private static Class<? extends Entity> getEntityClass(String entityType) {
        switch (entityType) {
            case "jesterknight": {
                return JesterknightEntity.class;
            }
            case "dwarfgolem": {
                return DwarfgolemEntity.class;
            }
            case "observer": {
                return ObserverEntity.class;
            }
            case "corruptedknight": {
                return CorruptedknightEntity.class;
            }
        }
        return null;
    }
}

