/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.projectile;

import com.cerbon.bosses_of_mass_destruction.entity.BMDEntities;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.RiftBurst;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.projectile.BaseThrownItemProjectile;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.bosses_of_mass_destruction.util.BMDUtils;
import com.cerbon.cerbons_api.api.general.event.EventScheduler;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.general.particle.ClientParticleBuilder;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import com.cerbon.cerbons_api.api.static_utilities.Vec3Colors;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SporeBallProjectile
extends BaseThrownItemProjectile
implements GeoEntity {
    private final AnimatableInstanceCache animationFactory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final List<Vec3> circlePoints = MathUtils.buildBlockCircle((double)7.0);
    private final ClientParticleBuilder projectileParticles = new ClientParticleBuilder((ParticleOptions)BMDParticles.DISAPPEARING_SWIRL.get()).color(Vec3Colors.GREEN).colorVariation(0.4).scale(0.2f).brightness(0xF000F0);
    private final byte particle = (byte)5;
    private float impactedPitch = 0.0f;
    public float impactedTicks = 0.0f;
    public boolean impacted = false;
    public static final int explosionDelay = 30;

    public SporeBallProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
        this.collisionPredicate = hitResult -> true;
    }

    public SporeBallProjectile(LivingEntity livingEntity, Level level, Predicate<EntityHitResult> entityPredicate) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)BMDEntities.SPORE_BALL.get()), livingEntity, level, entityPredicate);
        this.collisionPredicate = hitResult -> true;
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        this.onImpact();
    }

    @Override
    public void clientTick() {
        super.clientTick();
        if (this.impacted) {
            this.impactedTicks += 1.0f;
        }
    }

    @NotNull
    public Vec3 m_20184_() {
        return !this.impacted ? super.m_20184_() : Vec3.f_82478_;
    }

    private void onImpact() {
        if (this.impacted) {
            return;
        }
        this.impactedPitch = this.m_146909_();
        this.impacted = true;
        Entity owner = this.m_19749_();
        if (owner instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)owner;
            this.doExplosion(livingEntity);
        } else if (!this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    public float m_146909_() {
        return this.impacted ? this.impactedPitch : (float)this.f_19797_ * 5.0f;
    }

    public float m_146908_() {
        return 0.0f;
    }

    private void doExplosion(LivingEntity owner) {
        this.m_9236_().m_7605_((Entity)this, (byte)5);
        this.m_5496_((SoundEvent)BMDSounds.SPORE_BALL_LAND.get(), 1.0f, SoundUtils.randomPitch((RandomSource)this.f_19796_) - 0.2f);
        EventScheduler eventScheduler = CapabilityUtils.getLevelEventScheduler((Level)this.m_9236_());
        Consumer<LivingEntity> onImpact = entity -> {
            float damage = (float)owner.m_21133_(Attributes.f_22281_);
            if (this.m_19749_() != null) {
                entity.m_6469_(BMDUtils.shieldPiercing(this.m_9236_(), this.m_19749_()), damage);
                entity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 140), this.m_19749_());
            }
        };
        if (!this.m_9236_().f_46443_) {
            RiftBurst riftBurst = new RiftBurst(owner, (ServerLevel)this.m_9236_(), (ParticleOptions)BMDParticles.SPORE_INDICATOR.get(), (ParticleOptions)BMDParticles.SPORE.get(), 30, eventScheduler, onImpact, this::isOpenBlock, this::posFinder);
            eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
                this.m_5496_((SoundEvent)BMDSounds.SPORE_IMPACT.get(), 1.5f, SoundUtils.randomPitch((RandomSource)this.f_19796_));
                this.m_146870_();
            }, 30));
            Vec3 center = VecUtils.asVec3((BlockPos)this.m_20183_()).m_82549_(VecUtils.unit.m_82490_(0.5));
            for (Vec3 point : this.circlePoints) {
                riftBurst.tryPlaceRift(center.m_82549_(point));
            }
        }
    }

    private BlockPos posFinder(Vec3 pos) {
        BlockPos above = BlockPos.m_274446_((Position)pos.m_82549_(VecUtils.yAxis.m_82490_(2.0)));
        BlockPos groundPos = BMDUtils.findGroundBelow(this.m_9236_(), above, pos1 -> true);
        BlockPos up = groundPos.m_7494_();
        return up.m_123342_() + 8 >= above.m_123342_() && this.isOpenBlock(up) ? up : null;
    }

    private boolean isOpenBlock(BlockPos up) {
        BlockState blockState = this.m_9236_().m_8055_(up);
        return blockState.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.m_9236_(), up, Direction.DOWN, ItemStack.f_41583_, Direction.UP)) || blockState.m_60734_() == Blocks.f_152543_;
    }

    public void m_7822_(byte id) {
        if (id == 5) {
            for (Vec3 point : MathUtils.circlePoints((double)0.8, (int)16, (Vec3)VecUtils.yAxis)) {
                this.projectileParticles.build(point.m_82549_(this.m_20182_()), point.m_82490_(0.1));
            }
        }
        super.m_7822_(id);
    }

    @Override
    public void entityHit(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Entity owner = this.m_19749_();
        Entity entity = entityHitResult.m_82443_();
        if (owner instanceof LivingEntity && entity != (livingEntity = (LivingEntity)owner)) {
            float damage = (float)livingEntity.m_21133_(Attributes.f_22281_);
            entity.m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)livingEntity), damage);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationFactory;
    }
}

