/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.zgmobs;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.IntFunction;
import net.frozenblock.zgmobs.Config;
import net.frozenblock.zgmobs.GermoniumUtils;
import net.frozenblock.zgmobs.mixin.CreeperMixin;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public enum Germonium implements StringRepresentable
{
    NORMAL(0, "normal"),
    INFERNIUM(1, "infernium"),
    CELESTIUM(2, "celestium");

    public static final StringRepresentable.EnumCodec<Germonium> CODEC;
    private static final IntFunction<Germonium> BY_ID;
    private final int id;
    private final String name;

    private Germonium(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public String m_7912_() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public static Germonium byName(String p_28817_) {
        return (Germonium)CODEC.m_262792_(p_28817_, (Enum)NORMAL);
    }

    public static Germonium byId(int p_28813_) {
        return BY_ID.apply(p_28813_);
    }

    public void setAttributes(AttributeMap attributes) {
        HashMap<Attribute, AttributeModifier> map = new HashMap<Attribute, AttributeModifier>();
        map.put(Attributes.f_22276_, Germonium.create(this.forVariant(0, 40, 80).intValue(), AttributeModifier.Operation.ADDITION));
        map.put(Attributes.f_22281_, Germonium.create(this.forVariant(0, 8, 12).intValue(), AttributeModifier.Operation.ADDITION));
        map.put(Attributes.f_22279_, Germonium.create(this.forVariant(0.0, 0.5, 0.65), AttributeModifier.Operation.MULTIPLY_BASE));
        map.put(Attributes.f_22278_, Germonium.create(this.forVariant(0.0, 0.4, 1.0), AttributeModifier.Operation.ADDITION));
        map.put(Attributes.f_22284_, Germonium.create(this.forVariant(0, 20, 25).intValue(), AttributeModifier.Operation.ADDITION));
        map.put(Attributes.f_22285_, Germonium.create(this.forVariant(0, 15, 20).intValue(), AttributeModifier.Operation.ADDITION));
        for (Map.Entry entry : map.entrySet()) {
            AttributeInstance instance = attributes.m_22146_((Attribute)entry.getKey());
            if (instance == null) continue;
            instance.m_22120_(((AttributeModifier)entry.getValue()).m_22209_());
            instance.m_22125_((AttributeModifier)entry.getValue());
        }
    }

    private <T> T forVariant(T normal, T infernium, T celestium) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NORMAL -> normal;
            case INFERNIUM -> infernium;
            case CELESTIUM -> celestium;
        };
    }

    private static AttributeModifier create(double amount, AttributeModifier.Operation operation) {
        return new AttributeModifier(UUID.fromString("d543eb83-b8b1-4626-b320-03b68395c448"), "zgmobs.variant.germonium", amount, operation);
    }

    public static void finalizeSpawn(Mob mob, @Nullable Germonium germonium) {
        if (mob instanceof Enemy) {
            boolean infernium;
            if (germonium == null && !((Boolean)Config.DISABLE_GERMONIUM.get()).booleanValue() && Math.random() * 100.0 > (double)((Integer)Config.GERMONIUM_BASE_CHANCE.get()).intValue()) {
                return;
            }
            if (germonium == NORMAL) {
                return;
            }
            if (mob instanceof Creeper) {
                Creeper creeper = (Creeper)mob;
                creeper.m_20088_().m_135381_(CreeperMixin.accessor$DATA_IS_POWERED(), (Object)true);
            }
            boolean bl = germonium == null ? Math.random() * 100.0 > (double)((Integer)Config.CELESTIUM_VARIANT.get()).intValue() : (infernium = germonium == INFERNIUM);
            if (infernium) {
                GermoniumUtils.setupInfernium(mob);
            } else {
                GermoniumUtils.setupCelestium(mob);
            }
            (infernium ? INFERNIUM : CELESTIUM).setAttributes(mob.m_21204_());
            mob.m_21153_(mob.m_21233_());
        }
    }

    static {
        CODEC = StringRepresentable.m_216439_(Germonium::values);
        BY_ID = ByIdMap.m_262839_(Germonium::getId, (Object[])Germonium.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
    }
}

