/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.screen;

import fin.starhud.Helper;
import fin.starhud.Main;
import fin.starhud.compat.ImmediatelyFastCompat;
import fin.starhud.config.BaseHUDSettings;
import fin.starhud.config.GeneralSettings;
import fin.starhud.config.Settings;
import fin.starhud.helper.Box;
import fin.starhud.helper.GrowthDirectionX;
import fin.starhud.helper.GrowthDirectionY;
import fin.starhud.helper.ScreenAlignmentX;
import fin.starhud.helper.ScreenAlignmentY;
import fin.starhud.hud.AbstractHUD;
import fin.starhud.hud.HUDComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class EditHUDScreen
extends Screen {
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private static final GeneralSettings.EditHUDScreenSettings SETTINGS = Main.settings.generalSettings.screenSettings;
    private static final int PADDING = 25;
    private static final int WIDGET_WIDTH = 100;
    private static final int WIDGET_HEIGHT = 20;
    private static final int TEXT_FIELD_WIDTH = 40;
    private static final int SQUARE_WIDGET_LENGTH = 20;
    private static final int GAP = 5;
    public Screen parent;
    private final List<AbstractHUD> huds;
    private final List<HUDCoordinate> oldSettings;
    private boolean dragging = false;
    private AbstractHUD selectedHUD = null;
    private boolean isHelpActivated = false;
    private boolean isMoreOptionActivated = false;
    private EditBox xField;
    private EditBox yField;
    private Button alignmentXButton;
    private Button alignmentYButton;
    private Button directionXButton;
    private Button directionYButton;
    private Button scaleButton;
    private static final boolean isMac = System.getProperty("os.name").toLowerCase().contains("mac");
    private static final String[] HELP_KEYS = new String[]{"[Arrow Keys]", "[\u21e7 Shift + Arrows]", isMac ? "[\u2318 Cmd + Arrows]" : "[Ctrl + Arrows]", "[\u2325 Alt + Arrows]", isMac ? "[\u2318 Cmd + R]" : "[Ctrl + R]", "[Click]", "[Drag]"};
    private static final String[] HELP_INFOS = new String[]{"Move HUD by 1", "Move HUD by 5", "Change Alignment", "Change Growth Direction", "Revert All Changes", "Select HUD", "Move HUD"};
    private static final int HELP_HEIGHT = 5 + HELP_KEYS.length * 9 + 5;
    private double accumulatedX = 0.0;
    private double accumulatedY = 0.0;

    public EditHUDScreen(Component title, Screen parent) {
        super(title);
        this.parent = parent;
        HUDComponent.getInstance().setShouldRenderInGameScreen(false);
        this.huds = new ArrayList<AbstractHUD>(HUDComponent.getInstance().huds);
        this.huds.add(HUDComponent.getInstance().effectHUD);
        this.oldSettings = new ArrayList<HUDCoordinate>();
        for (AbstractHUD p : this.huds) {
            BaseHUDSettings settings = p.getSettings();
            this.oldSettings.add(new HUDCoordinate(settings.x, settings.y, settings.originX, settings.originY, settings.growthDirectionX, settings.growthDirectionY, settings.scale));
        }
    }

    protected void m_7856_() {
        int CENTER_X = this.f_96543_ / 2;
        int CENTER_Y = this.f_96544_ / 2 + 12;
        HUDComponent.getInstance().updateAll();
        this.xField = new EditBox(EditHUDScreen.CLIENT.f_91062_, CENTER_X - 40 - 10 - 5, CENTER_Y - 25, 40, 20, (Component)Component.m_237113_((String)"X"));
        this.yField = new EditBox(EditHUDScreen.CLIENT.f_91062_, CENTER_X + 10 + 5, CENTER_Y - 25, 40, 20, (Component)Component.m_237113_((String)"Y"));
        this.alignmentXButton = Button.m_253074_((Component)Component.m_237113_((String)"X Alignment: N/A"), button -> {
            if (this.selectedHUD == null) {
                return;
            }
            this.selectedHUD.getSettings().originX = this.selectedHUD.getSettings().originX.next();
            this.selectedHUD.getSettings().growthDirectionX = this.selectedHUD.getSettings().growthDirectionX.recommendedScreenAlignment(this.selectedHUD.getSettings().originX);
            this.selectedHUD.update();
            this.alignmentXButton.m_93666_((Component)Component.m_237113_((String)("X Alignment: " + String.valueOf((Object)this.selectedHUD.getSettings().originX))));
        }).m_252987_(CENTER_X - 100 - 10 - 5, CENTER_Y - 50, 100, 20).m_253136_();
        this.alignmentYButton = Button.m_253074_((Component)Component.m_237113_((String)"Y Alignment: N/A"), button -> {
            if (this.selectedHUD == null) {
                return;
            }
            this.selectedHUD.getSettings().originY = this.selectedHUD.getSettings().originY.next();
            this.selectedHUD.getSettings().growthDirectionY = this.selectedHUD.getSettings().growthDirectionY.recommendedScreenAlignment(this.selectedHUD.getSettings().originY);
            this.selectedHUD.update();
            this.alignmentYButton.m_93666_((Component)Component.m_237113_((String)("Y Alignment: " + String.valueOf((Object)this.selectedHUD.getSettings().originY))));
        }).m_252987_(CENTER_X + 10 + 5, CENTER_Y - 50, 100, 20).m_253136_();
        this.scaleButton = Button.m_253074_((Component)Component.m_237113_((String)"N/A"), button -> {
            if (this.selectedHUD == null) {
                return;
            }
            this.selectedHUD.getSettings().scale = (this.selectedHUD.getSettings().scale + 1) % 7;
            this.selectedHUD.update();
            this.scaleButton.m_93666_((Component)Component.m_237113_((String)Integer.toString(this.selectedHUD.getSettings().scale)));
        }).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Scale"))).m_252987_(CENTER_X - 10, CENTER_Y - 50, 20, 20).m_253136_();
        this.directionXButton = Button.m_253074_((Component)Component.m_237113_((String)"X Direction: N/A"), button -> {
            if (this.selectedHUD == null) {
                return;
            }
            this.selectedHUD.getSettings().growthDirectionX = this.selectedHUD.getSettings().growthDirectionX.next();
            this.selectedHUD.update();
            this.directionXButton.m_93666_((Component)Component.m_237113_((String)("X Direction: " + String.valueOf((Object)this.selectedHUD.getSettings().growthDirectionX))));
        }).m_252987_(CENTER_X - 100 - 10 - 5, CENTER_Y - 75, 100, 20).m_253136_();
        this.directionYButton = Button.m_253074_((Component)Component.m_237113_((String)"Y Direction: N/A"), button -> {
            if (this.selectedHUD == null) {
                return;
            }
            this.selectedHUD.getSettings().growthDirectionY = this.selectedHUD.getSettings().growthDirectionY.next();
            this.selectedHUD.update();
            this.directionYButton.m_93666_((Component)Component.m_237113_((String)("Y Direction: " + String.valueOf((Object)this.selectedHUD.getSettings().growthDirectionY))));
        }).m_252987_(CENTER_X + 10 + 5, CENTER_Y - 75, 100, 20).m_253136_();
        this.xField.m_94151_(text -> {
            if (this.selectedHUD == null) {
                return;
            }
            try {
                this.selectedHUD.getSettings().x = Integer.parseInt(text);
                this.selectedHUD.update();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.yField.m_94151_(text -> {
            if (this.selectedHUD == null) {
                return;
            }
            try {
                this.selectedHUD.getSettings().y = Integer.parseInt(text);
                this.selectedHUD.update();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        Button helpButton = Button.m_253074_((Component)Component.m_237113_((String)"?"), button -> {
            this.isHelpActivated = !this.isHelpActivated;
            this.onHelpSwitched();
        }).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Help"))).m_252987_(CENTER_X - 20 - 2, this.f_96544_ - 20 - 5, 20, 20).m_253136_();
        Button moreOptionButton = Button.m_253074_((Component)Component.m_237113_((String)"+"), button -> {
            this.isMoreOptionActivated = !this.isMoreOptionActivated;
            this.onMoreOptionSwitched();
        }).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"More Options"))).m_252987_(CENTER_X + 2, this.f_96544_ - 20 - 5, 20, 20).m_253136_();
        int terminatorWidth = 70;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save & Quit"), button -> {
            AutoConfig.getConfigHolder(Settings.class).save();
            this.m_7379_();
        }).m_252987_(CENTER_X + 2 + 20 + 5, this.f_96544_ - 20 - 5, terminatorWidth, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> this.close()).m_252987_(CENTER_X - 2 - terminatorWidth - 20 - 5, this.f_96544_ - 20 - 5, terminatorWidth, 20).m_253136_());
        this.alignmentXButton.f_93624_ = false;
        this.directionXButton.f_93624_ = false;
        this.alignmentYButton.f_93624_ = false;
        this.directionYButton.f_93624_ = false;
        this.xField.f_93624_ = false;
        this.yField.f_93624_ = false;
        this.scaleButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)helpButton);
        this.m_142416_((GuiEventListener)moreOptionButton);
        this.m_142416_((GuiEventListener)this.alignmentXButton);
        this.m_142416_((GuiEventListener)this.alignmentYButton);
        this.m_142416_((GuiEventListener)this.directionXButton);
        this.m_142416_((GuiEventListener)this.directionYButton);
        this.m_142416_((GuiEventListener)this.scaleButton);
        this.m_142416_((GuiEventListener)this.xField);
        this.m_142416_((GuiEventListener)this.yField);
        this.updateFieldsFromSelectedHUD();
    }

    private void updateFieldsFromSelectedHUD() {
        if (this.xField == null || this.yField == null) {
            return;
        }
        if (this.selectedHUD == null) {
            this.xField.m_94186_(false);
            this.yField.m_94186_(false);
            this.xField.m_94144_("N/A");
            this.yField.m_94144_("N/A");
            this.alignmentXButton.m_93666_((Component)Component.m_237113_((String)"X Alignment: N/A"));
            this.directionXButton.m_93666_((Component)Component.m_237113_((String)"X Direction: N/A"));
            this.alignmentYButton.m_93666_((Component)Component.m_237113_((String)"Y Alignment: N/A"));
            this.directionYButton.m_93666_((Component)Component.m_237113_((String)"Y Direction: N/A"));
            this.scaleButton.m_93666_((Component)Component.m_237113_((String)"N/A"));
            this.alignmentXButton.f_93623_ = false;
            this.directionXButton.f_93623_ = false;
            this.alignmentYButton.f_93623_ = false;
            this.directionYButton.f_93623_ = false;
            this.scaleButton.f_93623_ = false;
        } else {
            BaseHUDSettings settings = this.selectedHUD.getSettings();
            this.xField.m_94144_(String.valueOf(settings.x));
            this.yField.m_94144_(String.valueOf(settings.y));
            this.alignmentXButton.m_93666_((Component)Component.m_237113_((String)("X Alignment: " + String.valueOf((Object)this.selectedHUD.getSettings().originX))));
            this.directionXButton.m_93666_((Component)Component.m_237113_((String)("X Direction: " + String.valueOf((Object)this.selectedHUD.getSettings().growthDirectionX))));
            this.alignmentYButton.m_93666_((Component)Component.m_237113_((String)("Y Alignment: " + String.valueOf((Object)this.selectedHUD.getSettings().originY))));
            this.directionYButton.m_93666_((Component)Component.m_237113_((String)("Y Direction: " + String.valueOf((Object)this.selectedHUD.getSettings().growthDirectionY))));
            this.scaleButton.m_93666_((Component)Component.m_237113_((String)Integer.toString(this.selectedHUD.getSettings().scale)));
            this.alignmentXButton.f_93623_ = true;
            this.directionXButton.f_93623_ = true;
            this.alignmentYButton.f_93623_ = true;
            this.directionYButton.f_93623_ = true;
            this.scaleButton.f_93623_ = true;
            this.xField.m_94186_(true);
            this.yField.m_94186_(true);
            if (this.isMoreOptionActivated) {
                this.alignmentXButton.f_93624_ = true;
                this.directionXButton.f_93624_ = true;
                this.alignmentYButton.f_93624_ = true;
                this.directionYButton.f_93624_ = true;
                this.xField.f_93624_ = true;
                this.yField.f_93624_ = true;
                this.scaleButton.f_93624_ = true;
            }
        }
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (EditHUDScreen.SETTINGS.shouldBatchHUDWithImmediatelyFast && Helper.isModPresent("immediatelyfast")) {
            ImmediatelyFastCompat.beginHudBatching();
            this.renderElements(context, mouseX, mouseY, delta);
            ImmediatelyFastCompat.endHudBatching();
        } else {
            this.renderElements(context, mouseX, mouseY, delta);
        }
    }

    public void renderElements(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.m_280509_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE);
        super.m_88315_(context, mouseX, mouseY, delta);
        if (this.isHelpActivated) {
            int CENTER_X = this.f_96543_ / 2;
            int CENTER_Y = this.f_96544_ / 2 + 12;
            this.renderHelp(context, CENTER_X, CENTER_Y + 5);
            if (this.selectedHUD != null) {
                this.renderHUDInformation(context, CENTER_X, CENTER_Y + 5 + HELP_HEIGHT + 5);
            }
        }
        if (this.xField.m_94213_() && this.yField.m_94213_()) {
            context.m_280056_(EditHUDScreen.CLIENT.f_91062_, "X:", this.xField.m_252754_() - 5 - 2 - 3, this.xField.m_252907_() + 6, -1, true);
            context.m_280056_(EditHUDScreen.CLIENT.f_91062_, ":Y", this.yField.m_252754_() + this.yField.m_5711_() + 3, this.yField.m_252907_() + 6, -1, true);
        }
        this.renderBoundingBoxes(context, mouseX, mouseY);
    }

    private void renderBoundingBoxes(GuiGraphics context, int mouseX, int mouseY) {
        for (AbstractHUD p : this.huds) {
            if (!p.shouldRender() || !p.render(context)) continue;
            Box boundingBox = p.getBoundingBox();
            int x = boundingBox.getX();
            int y = boundingBox.getY();
            int width = boundingBox.width();
            int height = boundingBox.getHeight();
            int color = boundingBox.getColor();
            int selectedColor = EditHUDScreen.SETTINGS.selectedBoxColor | Integer.MIN_VALUE;
            if (p.isScaled()) {
                context.m_280168_().m_85836_();
                p.setHUDScale(context);
                context.m_280637_(x, y, width, height, color);
                if (this.isHovered(x, y, width, height, mouseX, mouseY, p.getSettings().scale)) {
                    context.m_280509_(x, y, x + width, y + height, color & 0xFFFFFF | Integer.MIN_VALUE);
                }
                if (p == this.selectedHUD) {
                    context.m_280509_(x, y, x + width, y + height, selectedColor);
                }
                context.m_280168_().m_85849_();
                continue;
            }
            context.m_280637_(x, y, width, height, color);
            if (this.isHovered(x, y, width, height, mouseX, mouseY, p.getSettings().scale)) {
                context.m_280509_(x, y, x + width, y + height, color & 0xFFFFFF | Integer.MIN_VALUE);
            }
            if (p != this.selectedHUD) continue;
            context.m_280509_(x, y, x + width, y + height, selectedColor);
        }
    }

    private void renderHelp(GuiGraphics context, int x, int y) {
        int padding = 5;
        Objects.requireNonNull(EditHUDScreen.CLIENT.f_91062_);
        int lineHeight = 9;
        int maxKeyWidth = EditHUDScreen.CLIENT.f_91062_.m_92895_(HELP_KEYS[1]);
        int maxInfoWidth = EditHUDScreen.CLIENT.f_91062_.m_92895_(HELP_INFOS[3]);
        int width = padding + maxKeyWidth + padding + 1 + padding + maxInfoWidth + padding;
        int height = padding + lineHeight * HELP_KEYS.length + padding - 2;
        context.m_280509_(x -= width / 2, y -= padding, x + width, y + height, Integer.MIN_VALUE);
        for (int i = 0; i < HELP_KEYS.length; ++i) {
            String key = HELP_KEYS[i];
            String info = HELP_INFOS[i];
            context.m_280056_(EditHUDScreen.CLIENT.f_91062_, key, x + padding, y + padding, -1, false);
            context.m_280056_(EditHUDScreen.CLIENT.f_91062_, info, x + padding + maxKeyWidth + padding + 1 + padding, y + padding, -1, false);
            y += lineHeight;
        }
    }

    private void renderHUDInformation(GuiGraphics context, int x, int y) {
        String text = this.selectedHUD.getName();
        int textWidth = EditHUDScreen.CLIENT.f_91062_.m_92895_(text);
        int padding = 5;
        Objects.requireNonNull(EditHUDScreen.CLIENT.f_91062_);
        context.m_280509_((x -= textWidth / 2) - padding, y - padding, x + textWidth + padding, y + 9 - 2 + padding, Integer.MIN_VALUE);
        context.m_280056_(EditHUDScreen.CLIENT.f_91062_, text, x, y, -1, false);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (AbstractHUD hud : this.huds) {
                int height;
                int width;
                int y;
                if (!hud.shouldRender()) continue;
                Box boundingBox = hud.getBoundingBox();
                int scale = hud.getSettings().scale;
                int x = boundingBox.getX();
                if (!this.isHovered(x, y = boundingBox.getY(), width = boundingBox.width(), height = boundingBox.getHeight(), (int)mouseX, (int)mouseY, scale)) continue;
                this.selectedHUD = hud;
                this.dragging = true;
                this.updateFieldsFromSelectedHUD();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            this.xField.m_94144_(String.valueOf(this.selectedHUD.getSettings().x));
            this.yField.m_94144_(String.valueOf(this.selectedHUD.getSettings().y));
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && this.selectedHUD != null && button == 0) {
            double scaleFactor = this.selectedHUD.getSettings().getScaledFactor();
            this.accumulatedX += deltaX * scaleFactor;
            this.accumulatedY += deltaY * scaleFactor;
            int dx = 0;
            int dy = 0;
            if (Math.abs(this.accumulatedX) >= 1.0) {
                dx = (int)this.accumulatedX;
                this.accumulatedX -= (double)dx;
            }
            if (Math.abs(this.accumulatedY) >= 1.0) {
                dy = (int)this.accumulatedY;
                this.accumulatedY -= (double)dy;
            }
            if (dx != 0 || dy != 0) {
                this.selectedHUD.getSettings().x += dx;
                this.selectedHUD.getSettings().y += dy;
                this.selectedHUD.update();
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.selectedHUD != null) {
            BaseHUDSettings settings = this.selectedHUD.getSettings();
            boolean handled = false;
            boolean isCtrl = isMac ? (modifiers & 8) != 0 : (modifiers & 2) != 0;
            boolean isShift = (modifiers & 1) != 0;
            boolean isAlt = (modifiers & 4) != 0;
            int step = isShift ? 5 : 1;
            switch (keyCode) {
                case 263: {
                    if (isCtrl) {
                        settings.originX = settings.originX.prev();
                        settings.growthDirectionX = settings.growthDirectionX.recommendedScreenAlignment(settings.originX);
                    } else if (isAlt) {
                        settings.growthDirectionX = settings.growthDirectionX.prev();
                    } else {
                        settings.x -= step;
                    }
                    handled = true;
                    break;
                }
                case 262: {
                    if (isCtrl) {
                        settings.originX = settings.originX.next();
                        settings.growthDirectionX = settings.growthDirectionX.recommendedScreenAlignment(settings.originX);
                    } else if (isAlt) {
                        settings.growthDirectionX = settings.growthDirectionX.next();
                    } else {
                        settings.x += step;
                    }
                    handled = true;
                    break;
                }
                case 265: {
                    if (isCtrl) {
                        settings.originY = settings.originY.prev();
                        settings.growthDirectionY = settings.growthDirectionY.recommendedScreenAlignment(settings.originY);
                    } else if (isAlt) {
                        settings.growthDirectionY = settings.growthDirectionY.prev();
                    } else {
                        settings.y -= step;
                    }
                    handled = true;
                    break;
                }
                case 264: {
                    if (isCtrl) {
                        settings.originY = settings.originY.next();
                        settings.growthDirectionY = settings.growthDirectionY.recommendedScreenAlignment(settings.originY);
                    } else if (isAlt) {
                        settings.growthDirectionY = settings.growthDirectionY.next();
                    } else {
                        settings.y += step;
                    }
                    handled = true;
                    break;
                }
                case 82: {
                    if (!isCtrl) break;
                    this.revertChanges();
                    handled = true;
                    break;
                }
                case 45: {
                    if (this.yField.m_93696_() || this.xField.m_93696_()) break;
                    settings.scale = (settings.scale + 6) % 7;
                    handled = true;
                    break;
                }
                case 61: {
                    if (!isShift || this.yField.m_93696_() || this.xField.m_93696_()) break;
                    settings.scale = (settings.scale + 1) % 7;
                    handled = true;
                }
            }
            if (handled) {
                this.selectedHUD.update();
                this.updateFieldsFromSelectedHUD();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean isHovered(int x, int y, int width, int height, int mouseX, int mouseY, int HUDScale) {
        float scale = HUDScale == 0 ? 1.0f : (float)CLIENT.m_91268_().m_85449_() / (float)HUDScale;
        int scaledMouseX = (int)((float)mouseX * scale);
        int scaledMouseY = (int)((float)mouseY * scale);
        return scaledMouseX >= x && scaledMouseX <= x + width && scaledMouseY >= y && scaledMouseY <= y + height;
    }

    private boolean isDirty() {
        for (int i = 0; i < this.huds.size(); ++i) {
            AbstractHUD hud = this.huds.get(i);
            BaseHUDSettings current = hud.getSettings();
            HUDCoordinate original = this.oldSettings.get(i);
            if (current.x == original.x && current.y == original.y && current.originX == original.alignmentX && current.originY == original.alignmentY && current.scale == original.scale) continue;
            return true;
        }
        return false;
    }

    private void revertChanges() {
        for (int i = 0; i < this.huds.size(); ++i) {
            BaseHUDSettings current = this.huds.get(i).getSettings();
            HUDCoordinate original = this.oldSettings.get(i);
            current.x = original.x;
            current.y = original.y;
            current.originX = original.alignmentX;
            current.originY = original.alignmentY;
            current.growthDirectionX = original.growthDirectionX;
            current.growthDirectionY = original.growthDirectionY;
            current.scale = original.scale;
        }
        AutoConfig.getConfigHolder(Settings.class).save();
    }

    public void m_7379_() {
        if (this.isDirty()) {
            this.f_96541_.m_91152_((Screen)new ConfirmScreen(result -> {
                if (result) {
                    this.revertChanges();
                    this.close();
                } else {
                    this.f_96541_.m_91152_((Screen)this);
                }
            }, (Component)Component.m_237113_((String)"Discard Changes?"), (Component)Component.m_237113_((String)"You have unsaved changes. Do you want to discard them?")));
        } else {
            this.close();
        }
    }

    public void close() {
        this.f_96541_.m_91152_(this.parent);
        HUDComponent.getInstance().setShouldRenderInGameScreen(true);
    }

    private void onHelpSwitched() {
    }

    private void onMoreOptionSwitched() {
        if (this.isMoreOptionActivated) {
            this.alignmentXButton.f_93624_ = true;
            this.directionXButton.f_93624_ = true;
            this.alignmentYButton.f_93624_ = true;
            this.directionYButton.f_93624_ = true;
            this.xField.f_93624_ = true;
            this.yField.f_93624_ = true;
            this.scaleButton.f_93624_ = true;
        } else {
            this.alignmentXButton.f_93624_ = false;
            this.directionXButton.f_93624_ = false;
            this.alignmentYButton.f_93624_ = false;
            this.directionYButton.f_93624_ = false;
            this.xField.f_93624_ = false;
            this.yField.f_93624_ = false;
            this.scaleButton.f_93624_ = false;
        }
    }

    private static class HUDCoordinate {
        int x;
        int y;
        ScreenAlignmentX alignmentX;
        ScreenAlignmentY alignmentY;
        GrowthDirectionX growthDirectionX;
        GrowthDirectionY growthDirectionY;
        int scale;

        public HUDCoordinate(int x, int y, ScreenAlignmentX alignmentX, ScreenAlignmentY alignmentY, GrowthDirectionX growthDirectionX, GrowthDirectionY growthDirectionY, int scale) {
            this.x = x;
            this.y = y;
            this.alignmentX = alignmentX;
            this.alignmentY = alignmentY;
            this.growthDirectionX = growthDirectionX;
            this.growthDirectionY = growthDirectionY;
            this.scale = scale;
        }
    }
}

