/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation;

import fin.starhud.Helper;
import fin.starhud.Main;
import fin.starhud.config.hud.TargetedCrosshairSettings;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class TargetedCrosshairHUD
extends AbstractHUD {
    private static final TargetedCrosshairSettings TARGETED_CROSSHAIR_SETTINGS = Main.settings.targetedCrosshairSettings;
    private static final ResourceLocation ICON_BACKGROUND_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/item.png");
    private static final ResourceLocation ENTITY_ICON_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/targeted_icon_entity.png");
    private static final int ICON_BACKGROUND_WIDTH = 22;
    private static final int ICON_BACKGROUND_HEIGHT = 22;
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private static final int BASE_HUD_WIDTH = 33;
    private static final int BASE_HUD_HEIGHT = 22;
    private Block cachedBlock = null;
    private FormattedCharSequence cachedBlockName = null;
    private String cachedBlockModName = null;
    private int cachedBlockMaxWidth = -1;
    private Entity cachedTargetedEntity = null;
    private FormattedCharSequence cachedEntityName = null;
    private String cachedEntityModName = null;
    private int cachedEntityMaxWidth = -1;
    private int cachedIndex = -1;

    public TargetedCrosshairHUD() {
        super(TargetedCrosshairHUD.TARGETED_CROSSHAIR_SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Targeted Crosshair HUD";
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && TargetedCrosshairHUD.CLIENT.f_91077_ != null && TargetedCrosshairHUD.CLIENT.f_91077_.m_6662_() != HitResult.Type.MISS;
    }

    public static boolean shouldHUDRender() {
        if (!TargetedCrosshairHUD.TARGETED_CROSSHAIR_SETTINGS.base.shouldRender()) {
            return false;
        }
        return TargetedCrosshairHUD.CLIENT.f_91077_ != null && TargetedCrosshairHUD.CLIENT.f_91077_.m_6662_() != HitResult.Type.MISS;
    }

    @Override
    public boolean renderHUD(GuiGraphics context) {
        return switch (TargetedCrosshairHUD.CLIENT.f_91077_.m_6662_()) {
            case HitResult.Type.BLOCK -> this.renderBlockInfoHUD(context);
            case HitResult.Type.ENTITY -> this.renderEntityInfoHUD(context);
            default -> false;
        };
    }

    public boolean renderBlockInfoHUD(GuiGraphics context) {
        BlockPos pos = ((BlockHitResult)TargetedCrosshairHUD.CLIENT.f_91077_).m_82425_();
        BlockState blockState = TargetedCrosshairHUD.CLIENT.f_91073_.m_8055_(pos);
        Block block = blockState.m_60734_();
        Item blockItem = block.m_5456_();
        ItemStack blockStack = blockItem.m_7968_();
        if (!block.equals(this.cachedBlock)) {
            this.cachedBlock = block;
            this.cachedBlockName = blockItem == Items.f_41852_ ? Component.m_237115_((String)block.m_7705_()).m_7532_() : blockStack.m_41786_().m_7532_();
            this.cachedBlockModName = Helper.getModName(ForgeRegistries.BLOCKS.getKey((Object)block));
            int blockNameWidth = TargetedCrosshairHUD.CLIENT.f_91062_.m_92724_(this.cachedBlockName);
            int modNameWidth = TargetedCrosshairHUD.CLIENT.f_91062_.m_92895_(this.cachedBlockModName);
            this.cachedBlockMaxWidth = Math.max(modNameWidth, blockNameWidth) - 1;
        }
        int xTemp = this.x - TargetedCrosshairHUD.TARGETED_CROSSHAIR_SETTINGS.base.growthDirectionX.getGrowthDirection(this.cachedBlockMaxWidth);
        RenderUtils.drawTextureHUD(context, ICON_BACKGROUND_TEXTURE, xTemp, this.y, 0.0f, 0.0f, 22, 22, 22, 22);
        RenderUtils.fillRoundedRightSide(context, xTemp + 22 + 1, this.y, xTemp + 22 + 1 + 5 + this.cachedBlockMaxWidth + 5, this.y + 22, Integer.MIN_VALUE);
        context.m_280480_(blockStack, xTemp + 3, this.y + 3);
        RenderUtils.drawTextHUD(context, this.cachedBlockName, xTemp + 22 + 1 + 5, this.y + 3, TargetedCrosshairHUD.TARGETED_CROSSHAIR_SETTINGS.targetedNameColor | 0xFF000000, false);
        RenderUtils.drawTextHUD(context, this.cachedBlockModName, xTemp + 22 + 1 + 5, this.y + 22 - 3 - 7, TargetedCrosshairHUD.TARGETED_CROSSHAIR_SETTINGS.modNameColor | 0xFF000000, false);
        this.setBoundingBox(xTemp, this.y, 28 + this.cachedBlockMaxWidth + 5, 22);
        return true;
    }

    public boolean renderEntityInfoHUD(GuiGraphics context) {
        Entity targetedEntity = ((EntityHitResult)TargetedCrosshairHUD.CLIENT.f_91077_).m_82443_();
        if (!targetedEntity.equals((Object)this.cachedTargetedEntity)) {
            this.cachedTargetedEntity = targetedEntity;
            this.cachedEntityName = targetedEntity.m_7755_().m_7532_();
            this.cachedEntityModName = Helper.getModName(ForgeRegistries.ENTITY_TYPES.getKey((Object)targetedEntity.m_6095_()));
            int entityNameWidth = TargetedCrosshairHUD.CLIENT.f_91062_.m_92724_(this.cachedEntityName);
            int modNameWidth = TargetedCrosshairHUD.CLIENT.f_91062_.m_92895_(this.cachedEntityModName);
            this.cachedEntityMaxWidth = Math.max(entityNameWidth, modNameWidth) - 1;
            this.cachedIndex = this.getEntityIconIndex(targetedEntity);
        }
        int xTemp = this.x - TargetedCrosshairHUD.TARGETED_CROSSHAIR_SETTINGS.base.growthDirectionX.getGrowthDirection(this.cachedEntityMaxWidth);
        int color = this.getEntityIconColor(this.cachedIndex) | 0xFF000000;
        RenderUtils.drawTextureHUD(context, ENTITY_ICON_TEXTURE, xTemp, this.y, 0.0f, 22 * this.cachedIndex, 22, 22, 22, 110, color);
        RenderUtils.fillRoundedRightSide(context, xTemp + 22 + 1, this.y, xTemp + 22 + 1 + 5 + this.cachedEntityMaxWidth + 5, this.y + 22, Integer.MIN_VALUE);
        RenderUtils.drawTextHUD(context, this.cachedEntityName, xTemp + 22 + 1 + 5, this.y + 3, color, false);
        RenderUtils.drawTextHUD(context, this.cachedEntityModName, xTemp + 22 + 1 + 5, this.y + 22 - 3 - 7, TargetedCrosshairHUD.TARGETED_CROSSHAIR_SETTINGS.modNameColor | 0xFF000000, false);
        this.setBoundingBox(xTemp, this.y, 28 + this.cachedEntityMaxWidth + 5, 22, color);
        return true;
    }

    private int getEntityIconIndex(Entity e) {
        if (TargetedCrosshairHUD.isHostileMob(e)) {
            return 0;
        }
        if (TargetedCrosshairHUD.isAngerableMob(e)) {
            return 1;
        }
        if (TargetedCrosshairHUD.isPassiveMob(e)) {
            return 2;
        }
        if (TargetedCrosshairHUD.isPlayerEntity(e)) {
            return 3;
        }
        return 4;
    }

    private int getEntityIconColor(int index) {
        return switch (index) {
            case 0 -> TargetedCrosshairHUD.TARGETED_CROSSHAIR_SETTINGS.entityColors.hostile;
            case 1 -> TargetedCrosshairHUD.TARGETED_CROSSHAIR_SETTINGS.entityColors.angerable;
            case 2 -> TargetedCrosshairHUD.TARGETED_CROSSHAIR_SETTINGS.entityColors.passive;
            case 3 -> TargetedCrosshairHUD.TARGETED_CROSSHAIR_SETTINGS.entityColors.player;
            default -> TargetedCrosshairHUD.TARGETED_CROSSHAIR_SETTINGS.entityColors.unknown;
        };
    }

    private static boolean isHostileMob(Entity e) {
        if (e instanceof EnderDragon) {
            return true;
        }
        if (e instanceof EnderDragonPart) {
            return true;
        }
        return e instanceof Enemy;
    }

    private static boolean isAngerableMob(Entity e) {
        return e instanceof NeutralMob;
    }

    private static boolean isPassiveMob(Entity e) {
        if (e instanceof AgeableMob) {
            return true;
        }
        if (e instanceof WaterAnimal) {
            return true;
        }
        if (e instanceof Allay) {
            return true;
        }
        return e instanceof SnowGolem;
    }

    private static boolean isPlayerEntity(Entity e) {
        return e instanceof Player;
    }

    @Override
    public int getBaseHUDWidth() {
        return 33;
    }

    @Override
    public int getBaseHUDHeight() {
        return 22;
    }
}

