/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation;

import fin.starhud.Main;
import fin.starhud.config.hud.InventorySettings;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class InventoryHUD
extends AbstractHUD {
    private static final InventorySettings INVENTORY_SETTINGS = Main.settings.inventorySettings;
    private static final ResourceLocation INVENTORY_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/inventory.png");
    private static final ResourceLocation INVENTORY_TEXTURE_VERTICAL = ResourceLocation.m_214293_((String)"starhud", (String)"hud/inventory_vertical.png");
    private static final int[] SLOT_X_HORIZONTAL = new int[27];
    private static final int[] SLOT_Y_HORIZONTAL = new int[27];
    private static final int[] SLOT_X_VERTICAL = new int[27];
    private static final int[] SLOT_Y_VERTICAL = new int[27];
    private static final int TEXTURE_WIDTH_HORIZONTAL = 206;
    private static final int TEXTURE_HEIGHT_HORIZONTAL = 68;
    private static final int TEXTURE_WIDTH_VERTICAL = 68;
    private static final int TEXTURE_HEIGHT_VERTICAL = 206;
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    @Override
    public String getName() {
        return "Inventory HUD";
    }

    public InventoryHUD() {
        super(InventoryHUD.INVENTORY_SETTINGS.base);
    }

    @Override
    public boolean renderHUD(GuiGraphics context) {
        if (InventoryHUD.INVENTORY_SETTINGS.drawVertical) {
            return this.drawInventoryVertical(context, this.x, this.y);
        }
        return this.drawInventoryHorizontal(context, this.x, this.y);
    }

    private boolean drawInventoryVertical(GuiGraphics context, int x, int y) {
        Inventory inventory = InventoryHUD.CLIENT.f_91074_.m_150109_();
        boolean foundItem = false;
        for (int itemIndex = 0; itemIndex < 27; ++itemIndex) {
            ItemStack stack = (ItemStack)inventory.f_35974_.get(itemIndex + 9);
            if (stack.m_41619_()) continue;
            if (!foundItem) {
                foundItem = true;
                RenderUtils.drawTextureHUD(context, INVENTORY_TEXTURE_VERTICAL, x, y, 0.0f, 0.0f, 68, 206, 68, 206);
            }
            int x1 = x + SLOT_X_VERTICAL[itemIndex];
            int y1 = y + SLOT_Y_VERTICAL[itemIndex];
            context.m_280480_(stack, x1, y1);
            context.m_280370_(InventoryHUD.CLIENT.f_91062_, stack, x1, y1);
        }
        this.setBoundingBox(x, y, 68, 206);
        return foundItem;
    }

    private boolean drawInventoryHorizontal(GuiGraphics context, int x, int y) {
        Inventory inventory = InventoryHUD.CLIENT.f_91074_.m_150109_();
        boolean foundItem = false;
        for (int itemIndex = 0; itemIndex < 27; ++itemIndex) {
            ItemStack stack = (ItemStack)inventory.f_35974_.get(itemIndex + 9);
            if (stack.m_41619_()) continue;
            if (!foundItem) {
                foundItem = true;
                RenderUtils.drawTextureHUD(context, INVENTORY_TEXTURE, x, y, 0.0f, 0.0f, 206, 68, 206, 68);
            }
            int x1 = x + SLOT_X_HORIZONTAL[itemIndex];
            int y1 = y + SLOT_Y_HORIZONTAL[itemIndex];
            context.m_280480_(stack, x1, y1);
            context.m_280370_(InventoryHUD.CLIENT.f_91062_, stack, x1, y1);
        }
        this.setBoundingBox(x, y, 206, 68);
        return foundItem;
    }

    private static void preComputeHorizontal() {
        int x1 = 3;
        int y1 = -20;
        for (int i = 0; i < 27; ++i) {
            if (i % 9 == 0) {
                y1 += 23;
                x1 = 3;
            }
            InventoryHUD.SLOT_X_HORIZONTAL[i] = x1;
            InventoryHUD.SLOT_Y_HORIZONTAL[i] = y1;
            x1 += 23;
        }
    }

    private static void preComputeVertical() {
        int x1 = 72;
        int y1 = 3;
        for (int i = 0; i < 27; ++i) {
            if (i % 9 == 0) {
                y1 = 3;
                x1 -= 23;
            }
            InventoryHUD.SLOT_X_VERTICAL[i] = x1;
            InventoryHUD.SLOT_Y_VERTICAL[i] = y1;
            y1 += 23;
        }
    }

    @Override
    public int getBaseHUDWidth() {
        return InventoryHUD.INVENTORY_SETTINGS.drawVertical ? 68 : 206;
    }

    @Override
    public int getBaseHUDHeight() {
        return InventoryHUD.INVENTORY_SETTINGS.drawVertical ? 206 : 68;
    }

    static {
        InventoryHUD.preComputeHorizontal();
        InventoryHUD.preComputeVertical();
    }
}

