/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation;

import fin.starhud.Main;
import fin.starhud.config.hud.DaySettings;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class DayHUD
extends AbstractHUD {
    private static final DaySettings DAY_SETTINGS = Main.settings.daySettings;
    private static final ResourceLocation DAY_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/day.png");
    private static final int TEXTURE_HEIGHT = 13;
    private static final int TEXTURE_WIDTH = 24;
    private long lastDay = -1L;
    private int cachedTextWidth;
    private String cachedDayString;
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public DayHUD() {
        super(DayHUD.DAY_SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Day HUD";
    }

    @Override
    public boolean renderHUD(GuiGraphics context) {
        long day = DayHUD.CLIENT.f_91073_.m_8044_() / 24000L;
        if (day != this.lastDay) {
            this.lastDay = day;
            this.cachedDayString = Long.toString(day);
            this.cachedTextWidth = DayHUD.CLIENT.f_91062_.m_92895_(this.cachedDayString);
        }
        int xTemp = this.x - DayHUD.DAY_SETTINGS.base.growthDirectionX.getGrowthDirection(this.cachedTextWidth);
        int color = DayHUD.DAY_SETTINGS.color | 0xFF000000;
        RenderUtils.drawTextureHUD(context, DAY_TEXTURE, xTemp, this.y, 0.0f, 0.0f, 13, 13, 13, 13);
        RenderUtils.fillRoundedRightSide(context, xTemp + 14, this.y, xTemp + 14 + this.cachedTextWidth + 9, this.y + 13, Integer.MIN_VALUE);
        RenderUtils.drawTextHUD(context, this.cachedDayString, xTemp + 19, this.y + 3, color, false);
        this.setBoundingBox(xTemp, this.y, 14 + this.cachedTextWidth + 9, 13, color);
        return true;
    }

    @Override
    public int getBaseHUDWidth() {
        return 24;
    }

    @Override
    public int getBaseHUDHeight() {
        return 13;
    }
}

