/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation;

import fin.starhud.Main;
import fin.starhud.config.hud.CoordSettings;
import fin.starhud.helper.Box;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class CoordinateHUD
extends AbstractHUD {
    private static final CoordSettings COORD_SETTINGS = Main.settings.coordSettings;
    private static final ResourceLocation COORD_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/coordinate.png");
    private static final int TEXTURE_WIDTH = 65;
    private static final int TEXTURE_HEIGHT = 13;
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private static boolean needBoxUpdate = true;
    private static final Box tempBox = new Box(0, 0);

    public CoordinateHUD() {
        super(CoordinateHUD.COORD_SETTINGS.base);
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && (CoordinateHUD.COORD_SETTINGS.X.shouldRender || CoordinateHUD.COORD_SETTINGS.Y.shouldRender || CoordinateHUD.COORD_SETTINGS.Z.shouldRender);
    }

    @Override
    public String getName() {
        return "Coordinate HUD";
    }

    @Override
    public boolean renderHUD(GuiGraphics context) {
        Vec3 vec3d = CoordinateHUD.CLIENT.f_91074_.m_20182_();
        String coordX = Integer.toString((int)vec3d.f_82479_);
        String coordY = Integer.toString((int)vec3d.f_82480_);
        String coordZ = Integer.toString((int)vec3d.f_82481_);
        int colorX = CoordinateHUD.COORD_SETTINGS.X.color | 0xFF000000;
        int colorY = CoordinateHUD.COORD_SETTINGS.Y.color | 0xFF000000;
        int colorZ = CoordinateHUD.COORD_SETTINGS.Z.color | 0xFF000000;
        if (CoordinateHUD.COORD_SETTINGS.X.shouldRender) {
            this.renderEachCoordinate(context, coordX, this.x + CoordinateHUD.COORD_SETTINGS.X.xOffset, this.y + CoordinateHUD.COORD_SETTINGS.X.yOffset, 0.0f, 65, 13, colorX);
        }
        if (CoordinateHUD.COORD_SETTINGS.Y.shouldRender) {
            this.renderEachCoordinate(context, coordY, this.x + CoordinateHUD.COORD_SETTINGS.Y.xOffset, this.y + CoordinateHUD.COORD_SETTINGS.Y.yOffset, 14.0f, 65, 13, colorY);
        }
        if (CoordinateHUD.COORD_SETTINGS.Z.shouldRender) {
            this.renderEachCoordinate(context, coordZ, this.x + CoordinateHUD.COORD_SETTINGS.Z.xOffset, this.y + CoordinateHUD.COORD_SETTINGS.Z.yOffset, 28.0f, 65, 13, colorZ);
        }
        needBoxUpdate = false;
        return true;
    }

    @Override
    public void update() {
        super.update();
        needBoxUpdate = true;
        this.boundingBox.setEmpty(true);
    }

    @Override
    public int getBaseHUDWidth() {
        return 65;
    }

    @Override
    public int getBaseHUDHeight() {
        return 13;
    }

    public void renderEachCoordinate(GuiGraphics context, String str, int x, int y, float v, int width, int height, int color) {
        RenderUtils.drawTextureHUD(context, COORD_TEXTURE, x, y, 0.0f, v, width, height, width, 41, color);
        RenderUtils.drawTextHUD(context, str, x + 19, y + 3, color, false);
        tempBox.setBoundingBox(x, y, width, height, color);
        if (needBoxUpdate) {
            if (this.boundingBox.isEmpty()) {
                this.boundingBox.setBoundingBox(tempBox.getX(), tempBox.getY(), tempBox.width(), tempBox.getHeight(), tempBox.getColor());
            } else {
                this.boundingBox.mergeWith(tempBox);
            }
        }
    }
}

