/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation;

import fin.starhud.Main;
import fin.starhud.config.hud.ClockSystemSettings;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ClockSystemHUD
extends AbstractHUD {
    private static final ClockSystemSettings CLOCK_SYSTEM_SETTINGS = Main.settings.clockSettings.systemSetting;
    private static final ResourceLocation CLOCK_12_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/clock_12.png");
    private static final ResourceLocation CLOCK_24_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/clock_24.png");
    private static final int TEXTURE_HEIGHT = 13;
    private static final SimpleDateFormat CLOCK_24_FORMAT = new SimpleDateFormat("HH:mm");
    private static final SimpleDateFormat CLOCK_12_FORMAT = new SimpleDateFormat("hh:mm a");
    private static String cachedSystemTimeString = ClockSystemHUD.buildSystemTime24String(System.currentTimeMillis());
    private static long cachedSystemMinute = -1L;
    private static final int TEXTURE_SYSTEM_12_WIDTH = 65;
    private static final int TEXTURE_SYSTEM_24_WIDTH = 49;

    public ClockSystemHUD() {
        super(ClockSystemHUD.CLOCK_SYSTEM_SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Clock System HUD";
    }

    @Override
    public boolean renderHUD(GuiGraphics context) {
        long currentTime = System.currentTimeMillis();
        long minute = currentTime / 60000L;
        boolean use12Hour = ClockSystemHUD.CLOCK_SYSTEM_SETTINGS.use12Hour;
        if (minute != cachedSystemMinute) {
            cachedSystemMinute = minute;
            cachedSystemTimeString = use12Hour ? ClockSystemHUD.buildSystemTime12String(currentTime) : ClockSystemHUD.buildSystemTime24String(currentTime);
        }
        int color = ClockSystemHUD.CLOCK_SYSTEM_SETTINGS.color | 0xFF000000;
        this.boundingBox.setColor(color);
        if (use12Hour) {
            RenderUtils.drawTextureHUD(context, CLOCK_12_TEXTURE, this.x, this.y, 0.0f, 0.0f, 65, 13, 65, 65, color);
            RenderUtils.drawTextHUD(context, cachedSystemTimeString, this.x + 19, this.y + 3, color, false);
            this.setBoundingBox(this.x, this.y, 65, 13, color);
        } else {
            RenderUtils.drawTextureHUD(context, CLOCK_24_TEXTURE, this.x, this.y, 0.0f, 0.0f, 49, 13, 49, 65, color);
            RenderUtils.drawTextHUD(context, cachedSystemTimeString, this.x + 19, this.y + 3, color, false);
            this.setBoundingBox(this.x, this.y, 49, 13, color);
        }
        return true;
    }

    private static String buildSystemTime24String(long time) {
        return CLOCK_24_FORMAT.format(new Date(time));
    }

    private static String buildSystemTime12String(long time) {
        return CLOCK_12_FORMAT.format(new Date(time));
    }

    @Override
    public int getBaseHUDWidth() {
        return ClockSystemHUD.CLOCK_SYSTEM_SETTINGS.use12Hour ? 65 : 49;
    }

    @Override
    public int getBaseHUDHeight() {
        return 13;
    }

    @Override
    public void update() {
        super.update();
        cachedSystemMinute = -1L;
    }
}

