/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation;

import fin.starhud.Main;
import fin.starhud.config.hud.ClockInGameSettings;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;

public class ClockInGameHUD
extends AbstractHUD {
    private static final ClockInGameSettings CLOCK_IN_GAME_SETTINGS = Main.settings.clockSettings.inGameSetting;
    private static final ResourceLocation CLOCK_12_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/clock_12.png");
    private static final ResourceLocation CLOCK_24_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/clock_24.png");
    private static final int TEXTURE_HEIGHT = 13;
    private static String cachedMinecraftTimeString = "";
    private static int cachedMinecraftMinute = -1;
    private static final int TEXTURE_INGAME_12_WIDTH = 65;
    private static final int TEXTURE_INGAME_24_WIDTH = 49;
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public ClockInGameHUD() {
        super(ClockInGameHUD.CLOCK_IN_GAME_SETTINGS.base);
    }

    @Override
    public String getName() {
        return "Clock In-Game HUD";
    }

    @Override
    public boolean renderHUD(GuiGraphics context) {
        ClientLevel world = ClockInGameHUD.CLIENT.f_91073_;
        long time = world.m_8044_() % 24000L;
        boolean use12Hour = ClockInGameHUD.CLOCK_IN_GAME_SETTINGS.use12Hour;
        int minutes = (int)(time % 1000L * 3L / 50L);
        int hours = (int)(time / 1000L + 6L) % 24;
        if (minutes != cachedMinecraftMinute) {
            cachedMinecraftMinute = minutes;
            cachedMinecraftTimeString = use12Hour ? ClockInGameHUD.buildMinecraftTime12String(hours, minutes) : ClockInGameHUD.buildMinecraftTime24String(hours, minutes);
        }
        int icon = ClockInGameHUD.getWeatherOrTime(world);
        int color = ClockInGameHUD.getIconColor(icon) | 0xFF000000;
        if (use12Hour) {
            RenderUtils.drawTextureHUD(context, CLOCK_12_TEXTURE, this.x, this.y, 0.0f, icon * 13, 65, 13, 65, 65, color);
            RenderUtils.drawTextHUD(context, cachedMinecraftTimeString, this.x + 19, this.y + 3, color, false);
            this.setBoundingBox(this.x, this.y, 65, 13, color);
        } else {
            RenderUtils.drawTextureHUD(context, CLOCK_24_TEXTURE, this.x, this.y, 0.0f, icon * 13, 49, 13, 49, 65, color);
            RenderUtils.drawTextHUD(context, cachedMinecraftTimeString, this.x + 19, this.y + 3, color, false);
            this.setBoundingBox(this.x, this.y, 49, 13, color);
        }
        return true;
    }

    private static int getIconColor(int icon) {
        return switch (icon) {
            case 1 -> ClockInGameHUD.CLOCK_IN_GAME_SETTINGS.color.day;
            case 2 -> ClockInGameHUD.CLOCK_IN_GAME_SETTINGS.color.night;
            case 3 -> ClockInGameHUD.CLOCK_IN_GAME_SETTINGS.color.rain;
            case 4 -> ClockInGameHUD.CLOCK_IN_GAME_SETTINGS.color.thunder;
            default -> 0xFFFFFF;
        };
    }

    private static int getWeatherOrTime(ClientLevel clientWorld) {
        if (clientWorld.m_46470_()) {
            return 4;
        }
        if (clientWorld.m_46471_()) {
            return 3;
        }
        if (clientWorld.m_46462_()) {
            return 2;
        }
        return 1;
    }

    private static String buildMinecraftTime24String(int hours, int minutes) {
        StringBuilder timeBuilder = new StringBuilder();
        if (hours < 10) {
            timeBuilder.append('0');
        }
        timeBuilder.append(hours).append(':');
        if (minutes < 10) {
            timeBuilder.append('0');
        }
        timeBuilder.append(minutes);
        return timeBuilder.toString();
    }

    private static String buildMinecraftTime12String(int hours, int minutes) {
        String period;
        StringBuilder timeBuilder = new StringBuilder();
        String string = period = hours >= 12 ? " PM" : " AM";
        if ((hours %= 12) == 0) {
            hours = 12;
        }
        timeBuilder.append(ClockInGameHUD.buildMinecraftTime24String(hours, minutes)).append(period);
        return timeBuilder.toString();
    }

    @Override
    public int getBaseHUDWidth() {
        return ClockInGameHUD.CLOCK_IN_GAME_SETTINGS.use12Hour ? 65 : 49;
    }

    @Override
    public int getBaseHUDHeight() {
        return 13;
    }

    @Override
    public void update() {
        super.update();
        cachedMinecraftMinute = -1;
    }
}

