/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud.implementation;

import fin.starhud.config.hud.HandSettings;
import fin.starhud.helper.Box;
import fin.starhud.helper.RenderUtils;
import fin.starhud.hud.AbstractHUD;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractHandHUD
extends AbstractHUD {
    private static final ResourceLocation HAND_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/hand.png");
    private static final ResourceLocation BIG_HAND_TEXTURE = ResourceLocation.m_214293_((String)"starhud", (String)"hud/big_hand.png");
    private static final int TEXTURE_WIDTH = 24;
    private static final int COUNT_WIDTH = 23;
    private static final int TEXTURE_HEIGHT = 13;
    private static final int ITEM_TEXTURE_WIDTH = 33;
    private static final int ITEM_TEXTURE_HEIGHT = 22;
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private final HandSettings handSettings;
    private final HumanoidArm arm;

    public AbstractHandHUD(HandSettings handSettings, HumanoidArm arm) {
        super(handSettings.base);
        this.handSettings = handSettings;
        this.arm = arm;
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && !AbstractHandHUD.CLIENT.f_91074_.m_21120_(AbstractHandHUD.CLIENT.f_91074_.m_5737_() == this.arm ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND).m_41619_();
    }

    @Override
    public boolean renderHUD(GuiGraphics context) {
        return this.renderHandHUD(context, this.arm, this.x, this.y);
    }

    public boolean renderHandHUD(GuiGraphics context, HumanoidArm arm, int x, int y) {
        Inventory playerInventory = AbstractHandHUD.CLIENT.f_91074_.m_150109_();
        ItemStack item = AbstractHandHUD.CLIENT.f_91074_.m_21120_(AbstractHandHUD.CLIENT.f_91074_.m_5737_() == arm ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        if (this.handSettings.showDurability && item.m_41763_()) {
            Box box = RenderUtils.renderDurabilityHUD(context, HAND_TEXTURE, item, x, y, this.getV(), 47, 27, this.handSettings.color | 0xFF000000, this.handSettings.drawBar, this.handSettings.renderItem, this.handSettings.base.growthDirectionX);
            this.copyBoundingBox(box);
        } else if (this.handSettings.showCount) {
            this.renderStackCountHUD(context, playerInventory, item, x -= this.handSettings.base.growthDirectionX.getGrowthDirection(23), y, this.getV(), this.handSettings.color | 0xFF000000);
        }
        return true;
    }

    private void renderStackCountHUD(GuiGraphics context, Inventory playerInventory, ItemStack stack, int x, int y, float v, int color) {
        if (this.handSettings.renderItem) {
            this.renderStackCountItemHUD(context, playerInventory, stack, x, y, color);
        } else {
            this.renderStackCountIconHUD(context, playerInventory, stack, x, y, v, color);
        }
    }

    private void renderStackCountItemHUD(GuiGraphics context, Inventory playerInventory, ItemStack stack, int x, int y, int color) {
        int stackAmount = AbstractHandHUD.getItemCount(playerInventory, stack);
        String amountStr = Integer.toString(stackAmount);
        RenderUtils.drawTextureHUD(context, BIG_HAND_TEXTURE, x, y, 0.0f, 0.0f, 56, 22, 56, 22);
        context.m_280480_(stack, x + 3, y + 3);
        RenderUtils.drawTextHUD(context, amountStr, x + 22 + 1 + (28 - AbstractHandHUD.CLIENT.f_91062_.m_92895_(amountStr) + 5) / 2, y + 7, color, false);
        this.setBoundingBox(x, y, 56, 22, color);
    }

    private void renderStackCountIconHUD(GuiGraphics context, Inventory playerInventory, ItemStack stack, int x, int y, float v, int color) {
        int stackAmount = AbstractHandHUD.getItemCount(playerInventory, stack);
        RenderUtils.drawTextureHUD(context, HAND_TEXTURE, x, y, 0.0f, v, 47, 13, 47, 27, color);
        RenderUtils.drawTextHUD(context, Integer.toString(stackAmount), x + 19, y + 3, color, false);
        this.setBoundingBox(x, y, 47, 13, color);
    }

    private static int getItemCount(Inventory inventory, ItemStack stack) {
        int stackAmount = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack item = inventory.m_8020_(i);
            if (item.m_41619_() || !AbstractHandHUD.areItemsAndComponentsEqual(item, stack)) continue;
            stackAmount += item.m_41613_();
        }
        return stackAmount;
    }

    private static boolean areItemsAndComponentsEqual(ItemStack x, ItemStack y) {
        return x.m_150930_(y.m_41720_()) && Objects.equals(x.m_41783_(), y.m_41783_());
    }

    @Override
    public int getBaseHUDWidth() {
        return this.handSettings.renderItem ? 33 : 24;
    }

    @Override
    public int getBaseHUDHeight() {
        return this.handSettings.renderItem ? 22 : 13;
    }

    abstract int getV();
}

